/* $Id: init.c,v 1.1.1.1 2001/04/21 16:55:06 cegger Exp $
******************************************************************************

   LibGGI3D extension initialization.

   Copyright (C) 1999 Jon Taylor [taylorj@ggi-project.org]
 
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <string.h>

#include "3d_int.h"
#include <ggi/internal/plat.h>

/* Extension ID. Defaulting to -1 should make segfault on abuse more likely ... */
ggi_extid ggi3DID = -1;

void *_ggi3dconfhandle = NULL;
static char ggi3dconfstub[512] = GGI3DCONFDIR;
static char *ggi3dconfdir = ggi3dconfstub + GGI3DTAGLEN;

const char *ggi3d_get_confdir(void)
{
	return ggi3dconfdir;
}


static int changed(ggi_visual_t vis, int whatchanged)
{
	GGIDPRINT("changed() called for LibGGI3D extension - vis=%p, %i \n",
		  vis, whatchanged);

	switch(whatchanged) 
	{
		case GGI_CHG_APILIST:
		{
			int temp;
			char api[256], args[256];
			void *err;
			GGIDPRINT("changed() APILIST\n");
			for(temp = 0; 0 == ggiGetAPI(vis, temp, api, args); temp++) 
			{
				strcat(api,"-3d");
				GGIDPRINT("Trying #%d: %s(%s)\n", temp, api, args);
				err = _ggiAddDL(vis, api, args, NULL, GGI_DLTYPE_EXTENSION);
				GGIDPRINT("Loaded #%d: %s(%s) : %p\n", temp, api, args, err);
			}
		}
		break;
	}
	
	return 0;
}

static int _ggi_error(void) 
{ 
	return -1; 
}

static int GGI_ggi3d_flush(ggi_visual *vis, int x, int y, int w, int h, int tryFlag)
{
	ggi3dext *priv = LIBGGI_3DEXT(vis);

	printf("aaaaaaaaaaaaaa\n");
	/* First we do our GGI3D flushing... */
	ggi3d_flush(priv->visualmod);

	/* ...and then we call back to the original ggiFlush(). */
	priv->oldflush(vis, x, y, w, x, tryFlag);
	
	return 0;
}

int ggi3DInit(void)
{
	int err;
	const char *str;
	char conffile[1024];
	
	ggi3DID = ggiExtensionRegister("GGI3D", sizeof(ggi3dext), changed);
	GGIDPRINT("Initialized 3D extension. ID: %i\n", ggi3DID);
	
	err = ggInit();
	if (err != GGI_OK) {
		fprintf(stderr, "LibGGI3D: unable to initialize LibGG\n");
		return err;
	}
#if 0
	if ((_gii_safe_lock = ggLockCreate()) == NULL) {
		fprintf(stderr,"LibGGI3D: unable to initialize safe mutex.\n");
		ggExit();
		return GGI_EUNKNOWN;
	}
#endif
	sprintf(conffile, "%s/%s", ggi3d_get_confdir(), GGI3DCONFFILE);
	err = ggLoadConfig(conffile, &_ggi3dconfhandle);
	if (err != GGI_OK)
	{
//		ggLockDestroy(_ggi3d_safe_lock);
		ggExit();
		fprintf(stderr, "LibGGI3D: fatal error - could not load %s\n",
			conffile);
		return err;
	}
	
	return ggi3DID >= 0 ? 0 : -1;
}

int ggi3DExit(void)
{
	int rc;
	rc = ggiExtensionUnregister(ggi3DID);
	GGIDPRINT("Terminated 3D extension. rc=%i\n", rc);

	return rc;
}

int ggi3DAttach(ggi_visual_t vis)
{
	int rc;
	ggi3dext *priv;
	ggi3d_modp vismod;
	
	rc = ggiExtensionAttach(vis, ggi3DID);
	GGIDPRINT("Attached 3D extension to %p. rc=%i\n", vis, rc);

	if (rc == 0) 
	{	/* We are actually creating the primary instance. */
		memset(LIBGGI_3DEXT(vis), 0, sizeof(ggi3dext));
		
		/* Now we need to load the appropriate module
		 * to use as the "visual module" - the master
		 * control module of our visual.
		 */
		
		/* Always use the GGIVis module for now */
		
		vismod = ggi3d_load_module(vis, "ggivis");
		if (vismod == NULL)
		{
			printf("Unable to load visual module\n");
			return rc;
		}
		
		priv = LIBGGI_3DEXT(vis);
		priv->visualmod = vismod;
		priv->oldflush = vis->opdisplay->flush;
		vis->opdisplay->flush = GGI_ggi3d_flush;
	}
	
	return rc;
}

int ggi3DDetach(ggi_visual_t vis)
{
	int rc;
	rc = ggiExtensionDetach(vis, ggi3DID);
	GGIDPRINT("Detached 3D extension from %p. rc=%i\n", vis, rc);

	return rc;
}
