/* $Id: module.c,v 1.1.1.1 2001/04/21 16:55:06 cegger Exp $
******************************************************************************

   LibGGI3D Module functionality

   Copyright (C) 1998 1999 Jon Taylor [taylorj@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include <ggi3d/debug.h>
#include <ggi3d/module.h>
#include <ggi3d/internal.h>

/* Instantiate a module of the class what_kind. Returns a modp (handle) for 
 * the newly created module on success.
 */
ggi3d_modp ggi3d_load_module(ggi_visual_t vis, const char *modname)
{
	ggi3d_dlhandle *hand;
	ggi3d_modp mod;
	ggi3dfunc_modinit init;
	
	hand = _ggi3DLoadDL(modname);
	if (hand == NULL)
	{
		printf("ggi3d_load_module: load of %s failed\n", modname);
		return NULL;
	}
	
	init = hand->init;
	
	mod = (ggi3d_modp)init(vis, NULL, NULL);
	if (mod == NULL)
	{
		printf("ggi3d_load_module: init of %s failed\n", modname);
		return NULL;
	}
	
	return mod;
}

/* Send input to a module.
 */
int ggi3d_flush(ggi3d_modp self)
{
	return self->flush(self);
}

/* Send a command to a module.  Note that commands and data are defined 
 * by the module.
 */
int ggi3d_command(ggi_visual_t vis, ggi3d_modp self, int command, void *data_in, void *data_out)
{
	int rc;
	rc = self->command(vis, self, command, data_in, data_out);
	
	return rc;
}
