/*
 * LibGGI3D 
 * 
 * LibGGI visual module
 * 
 * Copyright (C) 1999 Jon Taylor [taylorj@ggi-project.org]
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <glib.h>

#include <ggi3d/modules/ggivis.h>

char identstr[] = "LibGGI visual 0.1";

/* We have no private data yet */
typedef struct 
{
	ggi_visual_t vis;	// Pointer to associated visual
	GList *linefifo;       	// Queued drawing ops
	GList *boxfifo;
} ggivis_private;

ggi3d_modp ggi3d_dlinit(ggi_visual_t vis, const char *args, void *argptr)
{
	ggi3d_modp modinfo;
	ggivis_private *priv;
	
	modinfo = malloc(sizeof(ggi3d_module));
	modinfo->destroy = ggivis_destroy;
	modinfo->flush = ggivis_flush;
	modinfo->command = ggivis_command;
	
	priv = malloc(sizeof(ggivis_private));
	priv->vis = vis;
	priv->linefifo = g_list_alloc();
	priv->boxfifo = g_list_alloc();
	modinfo->priv = priv;
	
	return modinfo;
}

int ggivis_flush(ggi3d_modp self);
int line_in(ggi3d_modp self, void *data_in, void *data_out);
int box_in(ggi3d_modp self, void *data_in, void *data_out);

/* Free the private data */
void ggivis_destroy(ggi3d_modp self)
{
	free(self->priv);
	return;
}

int ggivis_command(ggi_visual_t vis, ggi3d_modp self, int cmd, void *data_in, void *data_out)
{
	void *junk;
	char *temp = (char *)data_out;
	
	switch (cmd)
	{
		case CMD_GET_IDENT:
		sprintf(temp, "%s", identstr);
		data_out = temp;
		return 11;
		break;
		case CMD_GET_INTERFACE:
		return ggivis_get_interface(self, data_in, data_out);
		case CMD_FLUSH:
		ggivis_flush(self);
		return 2;
		break;
	}
	return 0;
}

int ggivis_get_interface(ggi3d_modp self, void *data_in, void *data_out)
{
	ggi3d_interface *iface = (ggi3d_interface *)data_in;
	
	printf("ggivis_get_interface called\n");
	
	/* Do we support this interface? */
	if (iface->type_in == GGI3D_TYPE_LINE)
	{
		data_out = (void *)line_in;
		return 1;
	}
	
	if (iface->type_in == GGI3D_TYPE_BOX)
	{
		data_out = (void *)box_in;
		return 1;
	}
	
	return 0; /* We don't support the requested interface */
}

int ggivis_flush(ggi3d_modp self)
{
	ggivis_private *priv = (ggivis_private *)self->priv;
	
	/* Flush all opqueues here */
	printf("ggivis_flush called\n");
	
	return 0;
	
}

int line_in(ggi3d_modp self, void *data_in, void *data_out)
{
	ggivis_private *priv = (ggivis_private *)self->priv;
	line *myline = (line *)data_in;
	
//	g_list_add(priv->linefifo, (line *)data_in);
}

int box_in(ggi3d_modp self, void *data_in, void *data_out)
{
	ggivis_private *priv = (ggivis_private *)self->priv;
	box *mybox = (box *)data_in;
	
//	g_list_add(priv->boxfifo, (box *)data_in);
}

	
