/*
 * LibGGI3D 
 * 
 * LibGGI Glide rasterization target
 * 
 * Copyright (C) 1999 Jon Taylor [taylorj@ggi-project.org]
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ggi3d/modules/ggivis.h>
#include <ggi3d/modules/debug.h>
#include <ggi3d/modules/globals.h>
#include <glib.h>
#include <ggi/ggi.h>

char identstr_glidevis[] = "Glidevis 0.1";

/* We have no private data yet */
typedef struct 
{
	unsigned int junk;
} glidevis_private;

void glidevis_dump_input(glidevis_input_t *glidevis_input);
void glidevis_dump_output();
void render_glidevis(GList *triangles);

/* Dump input */
void glidevis_dump_input(glidevis_input_t *glidevis_input)
{
}

/* Dump output */
void glidevis_dump_output()
{
}

/* Free the private data */
void glidevis_destroy(ggi3d_modp self)
{
	free(self->private);
	return;
}

int glidevis_command(ggi3d_modp self, int cmd, void *data_in, void *data_out)
{
        ggi3d_module_id GGI3D_DEBUG;
	ggi3d_modp debug;
	void *junk;
	object debug_input;
	glidevis_input_t *glidevis_input = (glidevis_input_t *)data_in;
	
	switch (cmd)
	{
		case CMD_GET_IDENT:
		data_out = (void *)identstr_glidevis;
		return 1;
		break;
		case CMD_DEBUG_DUMP_IN:
		GGI3D_DEBUG = ggi3d_register_module_class("Debugger", debug_construct);
		debug = ggi3d_create_module(GGI3D_DEBUG);
		debug_input.type = DEBUG_TYPE_GLIDEVIS;
		debug_input.the_object = data_in;
		printf("glidevis input:\n");
		printf("--------------\n");
		ggi3d_handle_input(debug, &debug_input, junk);
		return 1;
		break;
		case CMD_PROCESS:
		glidevis_handle(self, data_in, data_out);
		return 1;
		break;
	}
	return 0;
}

int glidevis_handle(ggi3d_modp self, void *data_in, void *data_out)
{
	glidevis_input_t *glidevis_input = (glidevis_input_t *)data_in;

//	data_out = render_glidevis(glidevis_input->triangles);

	return 0; /* We always handle all input in one gulp */
}

int glidevis_construct(ggi3d_modp self)
{
	glidevis_private *priv;
	
	if (NULL==(priv=self->private=malloc(sizeof(glidevis_private)))) 
	  return 1;
	self->destroy		= glidevis_destroy;
	self->handle_input	= glidevis_handle;
	self->command		= glidevis_command;

	return 0;
}

void render_glidevis(GList *triangles)
{
	// FIXME: Do stuff
}

