/*
 * LibGGI3D 
 * 
 * Pipelineing (target chaining) module
 * 
 * Copyright (C) 1999 Jon Taylor [taylorj@ggi-project.org]
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <ggi3d/modules/pipeline.h>
#include <ggi3d/modules/globals.h>
#include <ggi3d/modules/debug.h>
#include <glib.h>

char identstr_pipeline[] = "Pipeline 0.1";

/* We have no private data yet */
typedef struct 
{
	GList *modlist;		 /* Modules making up the pipeline */
} pipeline_private;

ggi3d_modp ggi3d_dlinit()
{
	ggi3d_modp modinfo;
	pipeline_private *priv;

	modinfo = malloc(sizeof(ggi3d_module));
	modinfo->destroy = pipeline_destroy;
	modinfo->handle_input = pipeline_handle;
	modinfo->command = pipeline_command;
	
	priv = malloc(sizeof(pipeline_private));
	modinfo->priv = priv;
	
	return modinfo;
}


void render(ggi3d_modp self);

/* Free the private data */
void pipeline_destroy(ggi3d_modp self)
{
	free(self->priv);
	return;
}

int pipeline_command(ggi3d_modp self, int cmd, void *data_in, void *data_out)
{
        ggi3d_module_id GGI3D_DEBUG;
	ggi3d_modp debug;
	void *junk;
	object debug_input;
	pipeline_input_t *pipeline_input = (pipeline_input_t *)data_in;
	
	switch (cmd)
	{
		case CMD_GET_IDENT:
		data_out = (void *)identstr_pipeline;
		return 1;
		break;
		case CMD_PROCESS:
		pipeline_handle(self, data_in, data_out);
		return 1;
//		case CMD_FLUSH:
//		flush(self);
//		return 1;
//		case CMD_SET_MODLIST:
//		set_modlist(self, data_in);
//		return 1;
//		break;
	}
	return 0;
}

int pipeline_handle(ggi3d_modp self, void *data_in, void *data_out)
{
	pipeline_input_t *pipeline_input = (pipeline_input_t *)data_in;

//	data_out = flush(data_in);

	return 0; /* We always handle all input in one gulp */
}

int pipeline_construct(ggi3d_modp self)
{
	pipeline_private *priv;
	
	if (NULL==(priv=self->priv=malloc(sizeof(pipeline_private)))) 
	  return 1;
	self->destroy		= pipeline_destroy;
	self->handle_input	= pipeline_handle;
	self->command		= pipeline_command;

	return 0;
}

void flush(pipeline_input_t *data_in)
{
	/* Traverse the pipeline in order,
	 * sending the output of each modules
	 * to the input of the next module
	 * in the module chain.
	 * Return the output of the last module.
	 */
}

