/* $Id: renderworld.c,v 1.1.1.1 2001/04/21 16:55:10 cegger Exp $
******************************************************************************

   LibGGI3D renderworld module

   Copyright (C) 1999 Jon Taylor [taylorj@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/
/* renderworld.c
 *
 * Generic LibGGI3D test module
 * 
 * Inputs: World data
 * 
 * Output: Rendered bitmap
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ggi3d/modules/globals.h>
#include <glib.h>
#include <ggi3d/module.h>
#include <ggi3d/debug.h>
#include <ggi3d/modules/renderworld.h>
#include <ggi3d/modules/tesselate.h>
#include <ggi3d/modules/zbuffer.h>
#include <ggi3d/modules/debug.h>
#include <ggi3d/modules/pipeline.h>
#include <ggi3d/modules/glidevis.h>
#include <ggi3d/modules/ggivis.h>

char identstr_renderworld[] = "Renderworld 0.1";

/* We have no private data yet */
typedef struct 
{
	unsigned int junk;
} renderworld_private;

ggi3d_interface renderworld_interface =
{
	INT_RENDERWORLD
};

ggi3d_modp ggi3d_dlinit()
{
	ggi3d_modp modinfo;
	renderworld_private *priv;

	modinfo = malloc(sizeof(ggi3d_module));
	modinfo->destroy = renderworld_destroy;
	modinfo->handle_input = renderworld_handle;
	modinfo->command = renderworld_command;
	
	priv = malloc(sizeof(renderworld_private));
	modinfo->priv = priv;
	
	return modinfo;
}

void renderworld(renderworld_input_t *world);

/* Free the private data */
void renderworld_destroy(ggi3d_modp self)
{
	free(self->priv);
	return;
}

int renderworld_command(ggi_visual_t vis, ggi3d_modp self, int cmd, void *data_in, void *data_out)
{
	ggi3d_module_id GGI3D_DEBUG;
	ggi3d_modp debug;
	void *junk;
	ggi3d_interface *interface;
	object debug_input;
	
	
	char *temp = (char *)data_out;
	switch (cmd)
	{
		case CMD_GET_IDENT:
		sprintf(temp, "%s", identstr_renderworld);
		data_out = temp;
		return 11;
		break;
		case CMD_GET_INTERFACE:
		interface = malloc(sizeof(ggi3d_interface));
		*(interface) = renderworld_interface;
		return (int)interface;
		case CMD_PROCESS:
		renderworld_handle(vis, self, data_in, data_out);
		return 2;
		break;
		return 3;
		break;
	}
	return 0;
}

int renderworld_handle(ggi_visual_t vis, ggi3d_modp self, void *data_in, void *data_out)
{
//	renderworld_private *priv=(renderworld_private *)self->priv;
	/* We currently don't make use of the private data field */

//	printf("I'm rendering!\n");
	renderworld((renderworld_input_t *)data_in);

	return 0; /* We always handle all input in one gulp */
}

void renderworld(renderworld_input_t *the_world)
{
	ggi3d_modp mod_tesselate, mod_zbuffer;
	ggi_visual_t *vis;
	ggi_mode mode;
	object *the_object;
	polygon *the_polygon;
	GList *polygon_list;
	void *junk;
	int target = GGI3D_TARGET_LIBGGI;
	zbuffer_input_t zbuffer_input;
	
	mod_tesselate = ggi3d_load_module(vis, "tesselate");
	if (mod_tesselate == NULL)
	{
		printf("renderworld: error loading tesselator\n");
		return;
	}
	
	mod_zbuffer = ggi3d_load_module(vis, "zbuffer");
	if (mod_zbuffer == NULL)
	{
		printf("renderworld: error loading zbuffer\n");
		return;
	}
		  
	
	the_object = (object *)(g_list_first(the_world->object_list)->data);
	the_polygon = (polygon *)the_object->the_object;
	polygon_list = g_list_alloc();
	polygon_list->data = the_polygon;
	zbuffer_input.polygon_list = polygon_list;
	zbuffer_input.light_list = the_world->light_list;
	zbuffer_input.visual = the_world->vis;
	
	ggi3d_command(vis, mod_zbuffer, CMD_PROCESS, &zbuffer_input, junk);
}
