/*
 * LibGGI3D 
 * 
 * Platonic object to polygon mesh tesselator
 * 
 * Copyright (C) 1998 Jon Taylor [taylorj@ggi-project.org]
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include <stdlib.h>

#include <ggi3d/modules/globals.h>
#include <ggi3d/modules/tesselate.h>
#include <meschach/matrix.h>
#include <glib.h>

char identstr_tesselate[] = "Tesselator 0.1";
	
/* We have no private data yet */
typedef struct
{
	
	unsigned int junk;
} tesselate_private;

ggi3d_modp ggi3d_dlinit()
{
	ggi3d_modp modinfo;
	tesselate_private *priv;

	modinfo = malloc(sizeof(ggi3d_module));
	modinfo->destroy = tesselate_destroy;
	modinfo->handle_input = tesselate_handle;
	modinfo->command = tesselate_command;
	
	priv = malloc(sizeof(tesselate_private));
	modinfo->priv = priv;
	
	return modinfo;
}


void tesselate(object *the_object);
void tesselate_dump_input(object *the_object);
void tesselate_dump_output();

/* Dump input */
void tesselate_dump_input(object *the_object)
{		
	
}
	
/* Dump output */
void tesselate_dump_output()
{
		
	printf("Camera: (X=%f, Y=%f, Z=%f, Theta=%f, Phi=%f, Alpha=%f, ",
	       0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
	printf("Near clip=%f, Far clip=%f)\n\n", 0.0, 0.0);
}
	
/* Free the private data */
void tesselate_destroy(ggi3d_modp self)
{
		
	free(self->priv);
	return;
}
	
int tesselate_command(ggi3d_modp self, int cmd, void *data_in, void *data_out)
{
		
	
	switch (cmd)
	{
		
	case CMD_GET_IDENT:
		data_out = (void *)identstr_tesselate;
		return 1;
		break;
	case CMD_DEBUG_DUMP_IN:
		tesselate_dump_input((object *)(data_in));
		return 1;
		break;
		return 1;
		break;
	}
	
	return 0;
}
	
	
int tesselate_handle(ggi3d_modp self, void *data_in, void *data_out)
{
		
	//      tesselate_private *priv=(tesselate_private *)self->priv;
	/* We currently don't make use of the private data field */
	
	tesselate((object *)data_in);
	
	
	return 0; /* We always handle all input in one gulp */
}
	
	
int tesselate_construct(ggi3d_modp self)
{
		
	tesselate_private *priv;
		
	if (NULL==(priv=self->priv=malloc(sizeof(tesselate_private))))
	  return 1;
	self->destroy           = tesselate_destroy;
	self->handle_input      = tesselate_handle;
	self->command           = tesselate_command;
	
	return 0;
}

void tesselate(object *the_object)
{
}


/* define_curve_array(): Read in parameters, create a curve
** object and add it to the OST.
*/
void define_curve_array(ggi_coord c1, ggi_coord c2, ggi_coord c3, ggi_coord c4,
		       char *name)
{
	curve *the_curve;
	object *the_curve_object;
//	coord_2d coord2d;
//	coord coord3d;
//	int i;
	
	the_curve = malloc(sizeof(curve));
	the_curve_object = malloc(sizeof(object));
	
/*	the_curve->name=name; */
	
	the_curve->c1 = c1;
	the_curve->c2 = c2;
	the_curve->c3 = c3;
	the_curve->c4 = c4;

	g_list_append(the_ost, (gpointer *)the_curve_object);
}

/*
** Create polygons from the control mesh - don't recurse
*/
void draw_control_mesh(patch_descriptor *the_patch_descriptor)
{
/*	GArray *the_control_mesh;
	GList *the_pvpl_item;
	int i, j;
	vertex the_vertex;
	
	the_control_mesh = g_array_new();
	
	*(rendering_attributes *)(the_pvpl_item->data)->rendering_attributes = the_attributes;
	
	for (i = 0; i <= 2; i++)
	{
		for (j = 0; j <= 2; j++)
		{
			
			 the_vertex.c = g_array_index(the_control_mesh[i][j]) * the_ctm;
			 vertex_list.construct(the_vertex, the_pvpl_item.the_geometry);
			 the_vertex.the_coordinate := the_control_mesh(i, j + 1) * the_ctm;
			 vertex_list.construct(the_vertex, the_pvpl_item.the_geometry);
			 the_vertex.the_coordinate := the_control_mesh(j + 1, i + 1) * the_ctm;
			 vertex_list.construct(the_vertex, the_pvpl_item.the_geometry);
			 the_vertex.the_coordinate := the_control_mesh(j + 1, i) * the_ctm;
			 vertex_list.construct(the_vertex, the_pvpl_item.the_geometry);
			 vertex_list.clear(the_pvpl_item.the_geometry);
			 pvp_list.construct(the_pvpl_item, visible_polygons);
 
		}
	} */
}


/* Adds two coordinates */
coord add_c(coord *c1, coord *c2)
{
	coord c3;
	c3.x = c1->x + c2->x;
	c3.y = c1->y + c2->y;
	c3.z = c1->z + c2->z;
	return c3;
}

/* Splits a mesh into two sub-meshes along the u axis */
void split_along_u(GArray *orig, GArray *low, GArray *high)
{
//	int i;
	
/*	for (i = 1; i <= 4; i++)
	{
		
		low[1, i) := orig(1, i);
		low(2, i) := add_c(orig(1, i), orig(2, i)) / 2.0;
		low(3, i) := add_c((low(2, i) / 2.0), (add_c(orig(2, i), orig(3, i)))) / 4.0;
      
		high(4, i) := orig(4, i);
		high(3, i) := add_c(orig(3, i), orig (2, i)) / 2.0;
		high(2, i) := add_c((high(3, i) / 2.0), (add_c(orig(2, i), orig(3, i)))) / 4.0;
 
		low(4, i) := add_c(low(3, i), high(2, i)) / 2.0;
		high(1, i) := low(4, i);
	} */
}

/* Splits a mesh into two sub-meshes along the v axis */
GArray *split_along_v(GArray *orig, GArray *low, GArray *high)
{
//	int i;

/*	for (i = 1; i <= 4; i++)
	{
		    
		low(i, 1) := orig(i, 1);
		low(i, 2) := add_c(orig(i, 1), orig(i, 2)) / 2.0;
		low(i, 3) := add_c((low(i, 2) / 2.0), (add_c(orig(i, 2), orig(i, 3)))) / 4.0;
		
		high(i, 4) := orig(i, 4);
		high(i, 3) := add_c(orig(i, 3), orig (i, 2)) / 2.0;
		high(i, 2) := add_c((high(i, 3) / 2.0), (add_c(orig(i, 2), orig(i, 3)))) / 4.0;
		
		low(i, 4) := add_c(low(i, 3), high(i, 2)) / 2.0;
		high(i, 1) := low(i, 4);
	} */
}


/* Splits a mesh into four sub-meshes */
void subdivide(GArray *the_control_mesh, GArray *ulvl, GArray *ulvh, GArray *uhvl, GArray *uhvh)
{
	GArray *low, *high;

	split_along_u(the_control_mesh, low, high);
	split_along_v(low, ulvl, ulvh);
	split_along_v(high, uhvl, uhvh);
}


void draw_bezier_surface(GArray *the_control_mesh, int level)
{
	polygon *the_pvpl_item;
	vertex the_vertex;
	
//	GArray *ulvlmesh, *ulvhmesh, *uhvlmesh, *uhvhmesh;
	
        // If max_level was reached, subdivide into polygons instead
        // of sub-meshes

	#define MAX_LEVEL 3

        if (level >= MAX_LEVEL) 
	{
		
/*		the_pvpl_item.rendering_attributes := the_attributes;

		the_vertex.the_coordinate := the_control_mesh(1,1) * the_ctm;
		vertex_list.construct(the_vertex, the_pvpl_item.the_geometry);
		the_vertex.the_coordinate := the_control_mesh(4,1) * the_ctm;
		vertex_list.construct(the_vertex, the_pvpl_item.the_geometry);
		the_vertex.the_coordinate := the_control_mesh(4,4) * the_ctm;
		vertex_list.construct(the_vertex, the_pvpl_item.the_geometry);
		the_vertex.the_coordinate := the_control_mesh(1,4) * the_ctm;
		vertex_list.construct(the_vertex, the_pvpl_item.the_geometry);

		vertex_list.clear(the_pvpl_item.the_geometry);
		pvp_list.construct(the_pvpl_item, visible_polygons);*/
	}
        else
	{
          // continue subdivision/recursion
//		subdivide(the_control_mesh, ulvlmesh, ulvhmesh, uhvlmesh, uhvhmesh);
//		draw_bezier_surface(ulvlmesh, level + 1);
//		draw_bezier_surface(ulvhmesh, level + 1);
//		draw_bezier_surface(uhvlmesh, level + 1);
//		draw_bezier_surface(uhvhmesh, level + 1);
	}
} 

// Draws a surface by recursively subdiving it into submeshes.polygons
void draw_patch_surface(patch_descriptor *the_patch_descriptor)
{
	int max_level = the_patch_descriptor->subdivision_level;
	draw_bezier_surface(the_patch_descriptor->the_mesh, max_level); 
}

// render_bezier_patch(): Takes a bezier patch object and recursively 
// subdivides it into polygons until maximum subdivision level is reached
int my_render_bezier_patch(GList *the_root, MAT the_ctm, 
attributes *attribs, GList *visible_polygons) {
	int max_level;
	patch_descriptor *the_patch_descriptor;

	/* Call the appropriate patch redering routine based on the patch's render mode */
	
	the_patch_descriptor = (patch_descriptor *)(the_root->data);

	#define RENDER_SURFACE 1
	#define RENDER_WIRE 2
	

	switch (the_patch_descriptor->render_mode)
	{
	case RENDER_SURFACE: draw_patch_surface(the_patch_descriptor); break;
	case RENDER_WIRE: draw_control_mesh(the_patch_descriptor); break;
	}
}

// rsweep_bezier_curve(): Sweep a 2d curve around to create a 3d surface patch object
// FIXME: Take curve parameters from function arguments and return a surface patch object
/*
void rsweep_bezier_curve()
{
	
  unit_quarter_circle_curve: constant curve_array :=
    ((1.0, 0.0, 0.0, 1.0), (1.0, 0.0, -0.5523, 1.0),
     (0.5523, 0.0, -1.0, 1.0), (0.0, 0.0, -1.0, 1.0));
  the_curve: objects(curve);
  the_curve_array: curve_array;
  curve_name, new_patch_name: name_string;
  curve_ptr: object_ptr;
  t1, t2, t3: transformation_matrix_3d.matrix;
  local_mesh_array: mesh_array;
  local_patch_descriptor: patch_descriptor;
  local_patch: objects(bezier_patch);
  i, j: integer;
begin
  get_name(curve_name);
  get_name(new_patch_name);

  -- check for optional parameters
  if not tugs_input.end_of_line then
    get_patch_render_mode(local_patch_descriptor.the_patch_render_mode);
  end if;
  if not tugs_input.end_of_line then
    case local_patch_descriptor.the_patch_render_mode is
      when line => get_integer(local_patch_descriptor.the_patch_num_steps);
      when surface => 
        get_integer(local_patch_descriptor.the_patch_subdivision_level);
      when others => null;
    end case;
  end if;

  curve_ptr := object_list.location_of(curve_name, the_object_symbol_table);
  the_curve := object_list.head_of(curve_ptr);
  the_curve_array := the_curve.the_curve_array;

  -- Build a local mesh array containing the 16 points of the 
  -- surface by sweeping each curve control point around a unit 
  -- circle, giving one mesh row:
  for i in 1..4 loop
    -- Form the transformations to translate a unit circle control point
    -- up to the current curve control point, and scale the unit circle
    -- control point in x and z by the curve control point x value.
    t1 := transformation_matrix_3d.translation(0.0, the_curve_array(i).y, 0.0);
    t2 := transformation_matrix_3d.scaling(the_curve_array(i).x, 1.0, 1.0);
    t3 := transformation_matrix_3d.scaling(1.0, 1.0, the_curve_array(i).x);

    -- Generate one row of the new mesh by transforming the unit circle points
    for j in 1..4 loop
      local_mesh_array(i, j) := unit_quarter_circle_curve(j) * t1 * t2 * t3;
    end loop;
  end loop;

  -- Build a new mesh object and put a pointer to it in a local patch 
  -- descriptor object
  local_patch_descriptor.the_mesh := 
    object_list.new_object(kind => mesh, name => blank_name, next => null,
                           the_mesh_array => local_mesh_array);

  local_patch.name := new_patch_name;
  local_patch.next := null;
  local_patch.the_patch_descriptor := local_patch_descriptor;

  object_list.construct(local_patch, the_object_symbol_table);

end rsweep_bezier_curve;
*/

void divide_by_h(GList *the_pvpl)
{
	GList *pvp_index;
	polygon *pvp;
	GList *vertex_index;
	vertex *vertex_geometry;
	
	pvp_index = the_pvpl;
	while (pvp_index != g_list_last(pvp_index))
	{
		
		pvp = (polygon *)(g_list_first(pvp_index)->data);
		vertex_index = pvp->vertex_list;

		while (vertex_index != g_list_last(vertex_index))
		{
			vertex_geometry = (vertex *)(vertex_index->data);
//			vertex_geometry->c = vertex_geometry->c / vertex_geometry->c.h;
			vertex_index = vertex_index->next;
		}
		pvp_index = pvp_index->next;
	}
}

void apply_view_transformation(GList *the_pvpl)
{
	GList *pvp_index;
	polygon *pvp;
	GList *vertex_index;
	vertex *vertex_geometry;

	pvp_index = the_pvpl;

	while (pvp_index != g_list_last(pvp_index))
	{
		pvp = (polygon *)(pvp_index->data);
		vertex_index = pvp->vertex_list;

		while (vertex_index != g_list_last(vertex_index))
		{
			vertex_geometry = (vertex *)(vertex_index->data);
//			vertex_geometry->c = matrix_multiply(vertex_geometry->c * the_vtm;
			vertex_index = vertex_index->next;
		}

		pvp_index = pvp_index->next;
	}
}

void apply_perspective_transformation(GList *the_pvpl)
{
	GList *pvp_index;
	polygon *pvp;
	GList *vertex_index;
	vertex *vertex_geometry;

	pvp_index = the_pvpl;

	while (pvp_index != g_list_last(pvp_index))
	{
		pvp = (polygon *)(pvp_index->data);
		vertex_index = pvp->vertex_list;

		while (vertex_index != g_list_last(vertex_index))
		{
			vertex_geometry = (vertex *)(vertex_index->data);
//			vertex_geometry->c = matrix_multiply(vertex_geometry->c * the_ptm;
			vertex_index = vertex_index->next;
		}

		pvp_index = pvp_index->next;
	}
}


void render_wireframe_image(char *object_name, GList *the_ost)
{

	GList *the_pvpl;
	GList *pvp_index;
	GList *vertex_index;
	polygon *pvp;
	vertex *the_vertex, *the_next_vertex;
	texture *the_texture;
	ggi_color pvp_color;

//	build_pvpl(the_pvpl, object_name, the_ost);
//	apply_viewing_transformation(the_pvpl);
//	clip_to_view_volume(the_pvpl);
	apply_perspective_transformation(the_pvpl);
	divide_by_h(the_pvpl);
//	calculate_plane_coefficients(the_pvpl);

//	if (backface_culling)
//	{
//		backface_cull(the_pvpl);
//	}

//	transform_to_ndc(the_pvpl);
	pvp_index = the_pvpl;

	while (pvp_index != g_list_last(pvp_index))
	{
		pvp = (polygon *)(pvp_index->data);
//		the_texture = (texture *)(pvp->texture);
		pvp_color = pvp->the_material.diffuse_rgb;
		vertex_index = pvp->vertex_list;
		the_vertex = (vertex *)(vertex_index->data);
		
//		move(the_vertex->c.x, the_vertex->c.y);
		vertex_index = vertex_index->next;

		while (vertex_index != g_list_last(vertex_index))
		{
			the_next_vertex = (vertex *)(vertex_index->data);
			//draw(the_next_vertex->c.x, the_next_vertex->c.y);
			vertex_index = vertex_index->next;
		}			
     
//		draw(the_vertex->c.x, the_vertex->c.y);
		pvp_index = pvp_index->next;
	}
}


void render_hsr_image(char *the_object, GList *the_ost, GList *the_light_list)
{ 
	GList *the_pvpl;  

//	build_pvpl(the_pvpl, the_object, the_ost);
	apply_view_transformation(the_pvpl);
//	create_view_lights(the_light_symbol_table, the_light_list);
//	calculate_surface_normals(the_pvpl);
//	calculate_vertex_normals(the_pvpl);
//	clip_to_view_volume(the_pvpl);
	apply_perspective_transformation(the_pvpl);
	divide_by_h(the_pvpl);
//	calculate_plane_coefficients(the_pvpl);

// 	if (backface_culling)
//	{
//		backface_cull(the_pvpl);
//	}
 
//	transform_to_ndc(the_pvpl);

	/* Need to render though LibGGI3D component(s) here */

//	render_z_buffer(the_pvpl, the_light_list);
}

void walk_tree(GList *root, MAT *ctm, 
		attributes *the_attributes,
		GList *the_pvpl)
{

	MAT *newtm;
	object *the_object;
	GList *subroot;
	GList *new_vertex_list;
	vertex *vertex_geometry;
	polygon *loc_pvpl;
//	component *the_component;
	attributes *newatts;
	GList *coord_index;
	GList *index;
	int i;

	the_object = (object *)(root->data);

	switch (the_object->type)
	{
		case OBJ_POLYHEDRON:
			index = (GList *)the_object->the_object;
			while (index != g_list_last(index))
			{
//				the_component = (struct component *)(index->data);
//				newtm = matrix_multiply(the_component->the_itm, the_ctm);
//				subroot = the_component->the_object;
				newatts = the_attributes;
				walk_tree(subroot, newtm, newatts, the_pvpl);
				index = index->next;
			}
			break;
		case OBJ_ASSEMBLY:
//			index = the_object->the_components;
			while (index != g_list_last(index))
			{
//				the_component = (struct component *)(index->data);
//				newtm = matrix_multiply(the_component.the_itm, the_ctm);
//				subroot = the_component->the_object;

//				if (the_component->the_attributes == default_attributes)
//				{
//					newatts = the_attributes;
//				}
//				else
//				{
//					newatts = the_component->the_attributes;
//				}

				walk_tree(subroot, newtm, newatts, the_pvpl);
				index = index->next;
			}
			break;
		case OBJ_POLYGON:
//			loc_pvpl->rendering_attributes = the_attributes;
//			coord_index = the_object->the_geometry;

			while (coord_index != g_list_last(coord_index))
			{
//				vertex_geometry->c = (*(coord *)(coord_index->data)) * the_ctm;
//				*(vertex_geometry) = loc_pvpl->the_coordinate;
				coord_index = coord_index->next;
			}

			g_list_append(the_pvpl, loc_pvpl);
			break;
	}
}

void build_pvpl(GList *the_pvpl, char *the_object_name, GList *the_ost)
{

	GList *the_object_loc;
	int i;
	MAT *identity_matrix;
	attributes *default_attributes;

//	the_object_loc = g_list_locate(the_object_name, the_ost);
	walk_tree(the_object_loc, identity_matrix, default_attributes, the_pvpl);
}


void render_object(char *object_name, int the_render_mode)
{
	GList *the_light_list;
	GList *the_pvpl;
	int i;

	/* Begin rendering */

	#define RENDER_WIRE 1
	#define RENDER_HSR 2

	switch (the_render_mode)
	{
		case RENDER_WIRE:
			render_wireframe_image(object_name, the_ost);
			break;
		case RENDER_HSR:
			render_hsr_image(object_name, the_ost, the_light_list);
			break;
		default:
			printf("Invalid rendermode %d\n", the_render_mode);
	}

	/* End rendering */
}

/* SET_CAMERA_POSITION */
void set_camera_position(float vrp_x, float vrp_y, float vrp_z,
			 float camera_radius, float camera_theta, float camera_phi,
			 float camera_alpha, float hither_clip, float yon_clip, float vp)
{
	float neg_inv_dist, the_vpd, the_vps;
  	MAT matrix_1, matrix_2, matrix_3, matrix_4;
	int the_vp_mode = 1;

	#define VP_MODE_SIZE 1
	#define VP_MODE_DISTANCE 2

	switch (the_vp_mode)
	{
		case VP_MODE_SIZE:
			the_vps = vp;
			the_vpd = 2.0 * camera_radius / the_vps;
			break;
		case VP_MODE_DISTANCE:
			the_vpd = vp;
			the_vps = 2.0 * camera_radius / the_vpd;
			break;
	}
 
//	matrix_1 = matrix_translation(-vrp_x, -vrp_y, -vrp_z);
//	matrix_2 = matrix_rotation(0.0, -camera_theta, 0.0);
//	matrix_3 = matrix_rotation(-camera_phi, 0.0, 0.0);
//	matrix_4 = matrix_rotation(0.0, 0.0, -camera_alpha);

//	the_vtm = matrix_1 * matrix_2 * matrix_3 * matrix_4;
//	neg_inv_dist = -(1.0 / camera_radius);
//	the_ptm = identity_matrix;
//	the_ptm[3][4] = neg_inv_dist;
}
