/*
******************************************************************************

   VIDEO implementation for X target - initialization.

   Display-X: initialization

   Copyright (C) 2001	Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "xvideo.h"


static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		   const char *args, void *argptr, uint32 *dlret)
{
	VIDEODPRINT_LIBS("GGIopen(%p, %p, %s, %p, %p) called for X_video sublib\n",
		vis, dlh, args ? args : "(NULL)", argptr, dlret);


	XVIDEO_PRIV(vis) = NULL;
#if 0
	XVIDEO_PRIV(vis) = malloc(sizeof(struct xvideo_priv));
	if (XVIDEO_PRIV(vis) == NULL) return GGI_ENOMEM;
#endif

#if 0
	LIBGGI_VIDEOEXT(vis)->tie = VIDEO_X_tie;

	LIBGGI_VIDEOEXT(vis)->setimage = VIDEO_X_setimage;

	LIBGGI_VIDEOEXT(vis)->setpos = VIDEO_X_setpos;
	LIBGGI_VIDEOEXT(vis)->move = VIDEO_X_move;

	LIBGGI_VIDEOEXT(vis)->setsize = VIDEO_X_setsize;
	LIBGGI_VIDEOEXT(vis)->setpriority = VIDEO_X_setpriority;
	LIBGGI_VIDEOEXT(vis)->setflags = VIDEO_X_setflags;

	LIBGGI_VIDEOEXT(vis)->setzoom = VIDEO_X_setzoom;

	LIBGGI_VIDEOEXT(vis)->show = VIDEO_X_show;
	LIBGGI_VIDEOEXT(vis)->hide = VIDEO_X_hide;

	LIBGGI_VIDEOEXT(vis)->enable = VIDEO_X_enable;
	LIBGGI_VIDEOEXT(vis)->disable = VIDEO_X_disable;
#endif


	*dlret = (GGI_DL_EXTENSION | GGI_DL_OPDISPLAY);
	return 0;
}	/* GGIopen */


static int GGIclose(ggi_visual *vis, struct ggi_dlhandle *dlh)
{
	VIDEODPRINT_LIBS("GGIclose(%p, %p) called for X_video sublib\n",
	       vis, dlh);

#if 0
	free(XVIDEO_PRIV(vis));
	XVIDEO_PRIV(vis) = NULL;
#endif

	return 0;
}	/* GGIclose */


int VIDEOdl_X_video(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GGIopen;
		return 0;
	case GGIFUNC_exit:
		*funcptr = NULL;
		return 0;
	case GGIFUNC_close:
		*funcptr = GGIclose;
		return 0;
	default:
		*funcptr = NULL;
	}	/* switch */

	return GGI_ENOTFOUND;
}	/* VIDEOdl_X_video */

/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
