/*
******************************************************************************

   VIDEO implementation for stubs target - initialization.

   Display-Stubs: initialization

   Copyright (C) 2001	Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "stubsvideo.h"


static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		   const char *args, void *argptr, uint32 *dlret)
{
	VIDEODPRINT_LIBS("GGIopen(%p, %p, %s, %p, %p) called for stubs_video sublib\n",
		vis, dlh, args ? args : "(NULL)", argptr, dlret);


	STUBSVIDEO_PRIV(vis) = NULL;
#if 0
	STUBSVIDEO_PRIV(vis) = malloc(sizeof(struct stubsvideo_priv));
	if (STUBSVIDEO_PRIV(vis) == NULL) return GGI_ENOMEM;
#endif

#if 0
	LIBGGI_VIDEOEXT(vis)->tie = VIDEO_stubs_tie;

	LIBGGI_VIDEOEXT(vis)->setimage = VIDEO_stubs_setimage;

	LIBGGI_VIDEOEXT(vis)->setpos = VIDEO_stubs_setpos;
	LIBGGI_VIDEOEXT(vis)->move = VIDEO_stubs_move;

	LIBGGI_VIDEOEXT(vis)->setsize = VIDEO_stubs_setsize;
	LIBGGI_VIDEOEXT(vis)->setpriority = VIDEO_stubs_setpriority;
	LIBGGI_VIDEOEXT(vis)->setflags = VIDEO_stubs_setflags;

	LIBGGI_VIDEOEXT(vis)->setzoom = VIDEO_stubs_setzoom;

	LIBGGI_VIDEOEXT(vis)->show = VIDEO_stubs_show;
	LIBGGI_VIDEOEXT(vis)->hide = VIDEO_stubs_hide;

	LIBGGI_VIDEOEXT(vis)->enable = VIDEO_stubs_enable;
	LIBGGI_VIDEOEXT(vis)->disable = VIDEO_stubs_disable;
#endif


	*dlret = (GGI_DL_EXTENSION | GGI_DL_OPDISPLAY);
	return 0;
}	/* GGIopen */


static int GGIclose(ggi_visual *vis, struct ggi_dlhandle *dlh)
{
	VIDEODPRINT_LIBS("GGIclose(%p, %p) called for stubs_video sublib\n",
	       vis, dlh);

#if 0
	free(STUBSVIDEO_PRIV(vis));
	STUBSVIDEO_PRIV(vis) = NULL;
#endif

	return 0;
}	/* GGIclose */


int VIDEOdl_stubs_video(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GGIopen;
		return 0;
	case GGIFUNC_exit:
		*funcptr = NULL;
		return 0;
	case GGIFUNC_close:
		*funcptr = GGIclose;
		return 0;
	default:
		*funcptr = NULL;
	}	/* switch */

	return GGI_ENOTFOUND;
}	/* VIDEOdl_stubs_video */

/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
