/*
******************************************************************************

   LibVIDEO: extension internals

   Copyright (C) 2001 Christoph Egger   [Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_VIDEO_INT_H
#define _GGI_VIDEO_INT_H

#include <ggi/internal/internal.h>
#include <ggi/galloc.h>


#define HAVE_STRUCT_VIDEO
#include <ggi/video.h>


__BEGIN_DECLS

/* Exported variables */
#ifdef BUILDING_LIBVIDEO
extern ggi_extid    _videoID;
#else
IMPORTVAR ggi_extid _videoID;
#endif

__END_DECLS



/* Internal data types */

enum videotype {
	VIDEO_VIDEO,	/* true video */
	VIDEO_EMUVIDEO,	/* emulated video */
};


struct ggi_emuvideo_t {
	/* used, when partly emulated 
	 * i.e. when libovl can't decompress the video in hw.
	 */
	ggiOvl_t ovl;

	/* used, when full emulated
	 */
	ggiBlt_t bob;
	void *backgr;
};



struct ggiVideo {

	struct ggiGA_resource_props prop_motor;
	struct ggiGA_resource_props prop_carb;
	struct ggiGA_resource_props prop_tank;


	ggi_visual_t vis;
	long x,y;	/* current position */
	long w,h;	/* the size of the STORAGE */

	/* current pos/size - needed for pixel-doubling and zooming */
	long cur_x, cur_y;
	long cur_w, cur_h;


	int hidecount;
	int disablecount;


	uint32 slot;
	uint32 flags;
	int zoomed;
	int isplaying;

	ggiBuf_t buf;
	ggiBuf_t buf_disabled;


	gpf_handle_t gpf_handle;
	struct gpf_fileinfo_t *fileinfo;


	/* The coordbase the resource is actually stored
	 * and handled by the target
	 */
	uint16 cb;

	/* This is the coordbase the user is working with.
	 * Can be any kind of supported coordbase.
	 */
	uint16 user_cb;

	enum videotype vtype;
	union {
		ggiOvl_t		video;
		struct ggi_emuvideo_t	emuvideo;
	} subtype;


	ggiVideoSoundStart	soundstart;
	ggiVideoSoundStop	soundstop;
	ggiVideoSoundPause	soundpause;
	ggiVideoSoundContinue	soundcontinue;
	ggiVideoSoundFetchData	soundfetchdata;
};



/* Data types for the API functions */
typedef int (VideoTie)(ggi_visual_t vis, ggiVideo_t video);

typedef int (VideoSetImage)(ggiVideo_t video, ggi_visual_t vis,
			long x, long y, unsigned char *alpha);


typedef int (VideoSetPos)(ggiVideo_t video, long x, long y);
typedef int (VideoMove)(ggiVideo_t video, long x, long y);

typedef int (VideoSetSize)(ggiVideo_t video, long w, long h);
typedef int (VideoSetPriority)(ggiVideo_t video, uint32 slot, int swap);
typedef int (VideoSetFlags)(ggiVideo_t video, enum ggiVideo_flags flags);

typedef int (VideoSetZoom)(ggiVideo_t video, long x, long y,
			long w, long h, int keep_ratio);

typedef int (VideoGetFrameRate)(ggiVideo_t video, enum ggiVideo_flags flags);


typedef int (VideoShow)(ggiVideo_t video);
typedef int (VideoHide)(ggiVideo_t video);

typedef int (VideoEnable)(ggiVideo_t video);
typedef int (VideoDisable)(ggiVideo_t video);


typedef struct videopriv {
	VideoTie		*tie;

	VideoSetImage		*setimage;

	VideoSetPos		*setpos;
	VideoMove		*move;

	VideoSetSize		*setsize;
	VideoSetPriority	*setpriority;
	VideoSetFlags		*setflags;

	VideoSetZoom		*setzoom;

	VideoGetFrameRate	*getframerate;

	VideoShow		*show;
	VideoHide		*hide;

	VideoEnable		*enable;
	VideoDisable		*disable;



	
	ggiGA_resource_list *reqlist;  /* Pointer to application provided 
					  "global" request list for lazy API */

	void *priv;	/* Here sublibs can store visual specific private data.
			   If you have more than one sublib (for each visual)
			   that needs private data, just add more pointers or
			   add the data fields directly in this structure. */
} videopriv;


/* Used to access the videopriv structure for a particular visual. */
#define LIBGGI_VIDEOEXT(vis) ((videopriv *)LIBGGI_EXT((vis),_videoID))



int _ggiVideoSync(ggiVideo_t video);


#endif /* _GGI_OVL_INT_H */
