/*
******************************************************************************

   VIDEO debugging macros

   Copyright (C) 2001 Christoph Egger	[Christoph_Egger@t-online.de]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _VIDEO_INTERNAL_DEBUG_H
#define _VIDEO_INTERNAL_DEBUG_H


#include <ggi/internal/video.h>

#include <stdio.h>
#include <stdarg.h>
#include <ggi/types.h>
#include <ggi/gg.h>



__BEGIN_DECLS

/* Exported variables */
#ifdef BUILDING_VIDEO
extern uint32     _videoDebugState;
extern int        _videoDebugSync;
#else
IMPORTVAR uint32  _videoDebugState;
IMPORTVAR int     _videoDebugSync;
#endif
__END_DECLS


/* Debugging types
 * bit 0 is reserved! */

#define VIDEODEBUG_CORE		(1<<1)	/*   2 */
#define VIDEODEBUG_MODE		(1<<2)	/*   4 */
#define VIDEODEBUG_COLOR		(1<<3)	/*   8 */
#define VIDEODEBUG_DRAW		(1<<4)	/*  16 */
#define VIDEODEBUG_MISC		(1<<5)	/*  32 */
#define VIDEODEBUG_LIBS		(1<<6)	/*  64 */
#define VIDEODEBUG_EVENTS		(1<<7)	/* 128 */

#define VIDEODEBUG_ALL	0xffffffff

#define DEBUG_INFO	__FILE__,__PRETTY_FUNCTION__,__LINE__

#ifdef DEBUG
#define LIB_ASSERT(x)	\
	if (!(x))	\
		fprintf(stderr,"LIBVIDEO:%s:%s:%d: assertion \"%s\" failed.\n", DEBUG_INFO, #x);
#else
#define LIB_ASSERT(x)	do{}while(0)
#endif


#ifdef __GNUC__

#ifdef DEBUG
#define VIDEODPRINT(args...)	   if (_videoDebugState) { ggDPrintf(_videoDebugSync, "LibVIDEO",args); }
#define VIDEODPRINT_CORE(args...)   if (_videoDebugState & VIDEODEBUG_CORE) { ggDPrintf(_videoDebugSync,"LibVIDEO",args); }
#define VIDEODPRINT_MODE(args...)   if (_videoDebugState & VIDEODEBUG_MODE) { ggDPrintf(_videoDebugSync,"LibVIDEO",args); }
#define VIDEODPRINT_COLOR(args...)  if (_videoDebugState & VIDEODEBUG_COLOR) { ggDPrintf(_videoDebugSync,"LibVIDEO",args); }
#define VIDEODPRINT_DRAW(args...)   if (_videoDebugState & VIDEODEBUG_DRAW) { ggDPrintf(_videoDebugSync,"LibVIDEO",args); }
#define VIDEODPRINT_MISC(args...)   if (_videoDebugState & VIDEODEBUG_MISC) { ggDPrintf(_videoDebugSync,"LibVIDEO",args); }
#define VIDEODPRINT_LIBS(args...)   if (_videoDebugState & VIDEODEBUG_LIBS) { ggDPrintf(_videoDebugSync,"LibVIDEO",args); }
#define VIDEODPRINT_EVENTS(args...) if (_videoDebugState & VIDEODEBUG_EVENTS) { ggDPrintf(_videoDebugSync,"LibVIDEO",args); }
#else /* DEBUG */
#define VIDEODPRINT(args...)		do{}while(0)
#define VIDEODPRINT_CORE(args...)	do{}while(0)
#define VIDEODPRINT_MODE(args...)	do{}while(0)
#define VIDEODPRINT_COLOR(args...)	do{}while(0)
#define VIDEODPRINT_DRAW(args...)	do{}while(0)
#define VIDEODPRINT_MISC(args...)	do{}while(0)
#define VIDEODPRINT_LIBS(args...)	do{}while(0)
#define VIDEODPRINT_EVENTS(args...)	do{}while(0)
#endif /* DEBUG */

#else /* __GNUC__ */

__BEGIN_DECLS

static inline void VIDEODPRINT(const char *form,...)
{
#ifdef DEBUG
	if (_videoDebugState) {
		va_list args;

		fprintf(stderr, "VIDEO: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_videoDebugSync) fflush(stderr);
	}
#endif
}

static inline void VIDEODPRINT_CORE(const char *form,...)
{
#ifdef DEBUG
	if (_videoDebugState & VIDEODEBUG_CORE) {
		va_list args;

		fprintf(stderr, "VIDEO: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_videoDebugSync) fflush(stderr);
	}
#endif
}

static inline void VIDEODPRINT_MODE(const char *form,...)
{
#ifdef DEBUG
	if (_videoDebugState & VIDEODEBUG_MODE) {
		va_list args;

		fprintf(stderr, "VIDEO: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_videoDebugSync) fflush(stderr);
	}
#endif
}

static inline void VIDEODPRINT_COLOR(const char *form,...)
{
#ifdef DEBUG
	if (_videoDebugState & VIDEODEBUG_COLOR) {
		va_list args;

		fprintf(stderr, "VIDEO: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_videoDebugSync) fflush(stderr);
	}
#endif
}

static inline void VIDEODPRINT_DRAW(const char *form,...)
{
#ifdef DEBUG
	if (_videoDebugState & VIDEODEBUG_DRAW) {
		va_list args;

		fprintf(stderr, "VIDEO: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_videoDebugSync) fflush(stderr);
	}
#endif
}

static inline void VIDEODPRINT_MISC(const char *form,...)
{
#ifdef DEBUG
	if (_videoDebugState & VIDEODEBUG_MISC) {
		va_list args;

		fprintf(stderr, "VIDEO: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_videoDebugSync) fflush(stderr);
	}
#endif
}

static inline void VIDEODPRINT_LIBS(const char *form,...)
{
#ifdef DEBUG
	if (_videoDebugState & VIDEODEBUG_LIBS) {
		va_list args;

		fprintf(stderr, "VIDEO: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_videoDebugSync) fflush(stderr);
	}
#endif
}

static inline void VIDEODPRINT_EVENTS(const char *form,...)
{
#ifdef DEBUG
	if (_videoDebugState & VIDEODEBUG_EVENTS) {
		va_list args;

		fprintf(stderr, "VIDEO: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_videoDebugSync) fflush(stderr);
	}
#endif
}

__END_DECLS

#endif /* __GNUC__ */

#ifdef DEBUG
#define VIDEO_ASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"VIDEO:%s:%d: INTERNAL ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#define VIDEO_APPASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"VIDEO:%s:%d: APPLICATION ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#else /* DEBUG */
#define VIDEO_ASSERT(x,str)	do{}while(0)
#define VIDEO_APPASSERT(x,str)	do{}while(0)
#endif /* DEBUG */

#ifdef DEBUG
# define VIDEOD0(x)	x
#else
# define VIDEOD0(x)	/* empty */
#endif

#ifdef VIDEODLEV
# if VIDEODLEV == 1
#  define VIDEOD1(x)	x
#  define VIDEOD2(x)	/* empty */
#  define VIDEOD3(x)	/* empty */
# elif VIDEODLEV == 2
#  define VIDEOD1(x)	x
#  define VIDEOD2(x)	x
#  define VIDEOD3(x)	/* empty */
# elif VIDEODLEV > 2
#  define VIDEOD1(x)	x
#  define VIDEOD2(x)	x
#  define VIDEOD3(x)	x
# endif
#else
# define VIDEOD1(x)	/* empty */
# define VIDEOD2(x)	/* empty */
# define VIDEOD3(x)	/* empty */
#endif

#endif /* _VIDEO_INTERNAL_DEBUG_H */
