/*
******************************************************************************

   LibVIDEO: extension stubs

   Copyright (C) 2001 Christoph Egger   [Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/video.h>
#include <ggi/internal/video_debug.h>
#include <ggi/internal/galloc_ops.h>


int ggiVideoSetImage(ggiVideo_t video, ggi_visual_t vis,
		long x, long y, unsigned char *alpha)
{
	switch (video->vtype) {
	case VIDEO_VIDEO:
		return ggiOvlSetImage(video->subtype.video, vis, x, y, alpha);

	case VIDEO_EMUVIDEO:
		return LIBGGI_VIDEOEXT(video->vis)->setimage(video,
							vis, x, y, alpha);
	}	/* switch */

	return GALLOC_EFAILED;
}	/* ggiVideoSetImage */



int ggiVideoSetPos(ggiVideo_t video, long x, long y)
{
	switch (video->vtype) {
	case VIDEO_VIDEO:
		return ggiOvlSetPos(video->subtype.video, x, y);
	case VIDEO_EMUVIDEO:
		return LIBGGI_VIDEOEXT(video->vis)->setpos(video, x, y);
	}	/* switch */

	return GALLOC_EFAILED;
}	/* ggiVideoSetPos */


int ggiVideoMove(ggiVideo_t video, long x, long y)
{
	switch (video->vtype) {
	case VIDEO_VIDEO:
		return ggiOvlMove(video->subtype.video, x, y);
	case VIDEO_EMUVIDEO:
		return LIBGGI_VIDEOEXT(video->vis)->move(video, x, y);
	}	/* switch */

	return GALLOC_EFAILED;
}	/* ggiVideoMove */




int ggiVideoSetSize(ggiVideo_t video, long w, long h)
{
	switch (video->vtype) {
	case VIDEO_VIDEO:
		return ggiOvlSetSize(video->subtype.video, w, h);
	case VIDEO_EMUVIDEO:
		return LIBGGI_VIDEOEXT(video->vis)->setsize(video, w, h);
	}	/* switch */

	return GALLOC_EFAILED;
}	/* ggiVideoSetSize */


int ggiVideoSetPriority(ggiVideo_t video, uint32 slot, int swap)
{
	switch (video->vtype) {
	case VIDEO_VIDEO:
		return ggiOvlSetPriority(video->subtype.video, slot, swap);
	case VIDEO_EMUVIDEO:
		return LIBGGI_VIDEOEXT(video->vis)->setpriority(video,
					slot, swap);
	}	/* switch */

	return GALLOC_EFAILED;
}	/* ggiVideoSetPriority */



int ggiVideoShow(ggiVideo_t video)
{
	switch (video->vtype) {
	case VIDEO_VIDEO:
		return ggiOvlShow(video->subtype.video);
	case VIDEO_EMUVIDEO:
		return LIBGGI_VIDEOEXT(video->vis)->show(video);
	}	/* switch */

	return GALLOC_EFAILED;
}	/* ggiVideoShow */


int ggiVideoHide(ggiVideo_t video)
{
	switch (video->vtype) {
	case VIDEO_VIDEO:
		return ggiOvlHide(video->subtype.video);
	case VIDEO_EMUVIDEO:
		return LIBGGI_VIDEOEXT(video->vis)->hide(video);
	}	/* switch */

	return GALLOC_EFAILED;
}	/* ggiVideoHide */


int ggiVideoIsHidden(ggiVideo_t video)
{
	switch (video->vtype) {
	case VIDEO_VIDEO:
		return ggiOvlIsHidden(video->subtype.video);
	case VIDEO_EMUVIDEO:
		return (video->hidecount > 0) ? 1 : 0;
	}	/* switch */

	return GALLOC_EFAILED;
}	/* ggiVideoIsHidden */




int ggiVideoEnable(ggiVideo_t video)
{
	switch (video->vtype) {
	case VIDEO_VIDEO:
		return ggiOvlEnable(video->subtype.video);
	case VIDEO_EMUVIDEO:
		return LIBGGI_VIDEOEXT(video->vis)->enable(video);
	}	/* switch */

	return GALLOC_EFAILED;
}	/* ggiVideoEnable */


int ggiVideoDisable(ggiVideo_t video)
{
	switch (video->vtype) {
	case VIDEO_VIDEO:
		return ggiOvlDisable(video->subtype.video);
	case VIDEO_EMUVIDEO:
		return LIBGGI_VIDEOEXT(video->vis)->disable(video);
	}	/* switch */

	return GALLOC_EFAILED;
}	/* ggiVideoDisable */


int ggiVideoIsEnabled(ggiVideo_t video)
{
	switch (video->vtype) {
	case VIDEO_VIDEO:
		return ggiOvlIsEnabled(video->subtype.video);
	case VIDEO_EMUVIDEO:
		return (video->disablecount > 0) ? 0 : 1;
	}	/* switch */

	return GALLOC_EFAILED;
}	/* ggiVideoIsEnabled */



int ggiVideoSetZoom(ggiVideo_t video, long x, long y, long w, long h, int keep_ratio)
{
	switch (video->vtype) {
	case VIDEO_VIDEO:
		return ggiOvlSetZoom(video->subtype.video,
					x,y, w, h, keep_ratio);
	case VIDEO_EMUVIDEO:
		return LIBGGI_VIDEOEXT(video->vis)->setzoom(video,
					x,y, w,h, keep_ratio);
	}	/* switch */

	return GALLOC_EFAILED;
}	/* ggiVideoSetZoom */



int ggiVideoGetFrameRate(ggiVideo_t video, enum ggiVideo_flags flags)
{
	switch (video->vtype) {
	case VIDEO_VIDEO:
		return ggiOvlGetFrameRate(video->subtype.video, flags);
	case VIDEO_EMUVIDEO:
		return LIBGGI_VIDEOEXT(video->vis)->getframerate(video,
					flags);
	}	/* switch */

	return GALLOC_EFAILED;
}	/* ggiVideoGetFrameRate */
