/*
******************************************************************************

   LibVIDEO: plain functions

   Copyright (C) 2001 Christoph Egger   [Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/video.h>
#include <ggi/internal/video_debug.h>
#include <ggi/internal/galloc_ops.h>



ggiGA_resource_handle ggiVideoGetMotorHandle(ggiVideo_t video)
{
	if (video == NULL) return NULL;

	return video->res_handle_motor;
}	/* ggiVideoGetMotorHandle */


ggiGA_resource_handle ggiVideoGetTankHandle(ggiVideo_t video)
{
	if (video == NULL) return NULL;

	return video->res_handle_tank;
}	/* ggiVideoGetTankHandle */


ggiGA_resource_handle ggiVideoGetCarbHandle(ggiVideo_t video)
{
	if (video == NULL) return NULL;

	return video->res_handle_carb;
}	/* ggiVideoGetCarbHandle */


gpf_handle_t ggiVideoGetGPFHandle(ggiVideo_t video)
{
	if (video == NULL) return NULL;

	return video->gpf_handle;
}	/* ggiVideoGetGPFHandle */



/* Fills properties with useful default values */
int ggiVideoClearMotorProperties(struct ggiGA_resource_props *prop)
{
	int rc = GALLOC_OK;
	LIB_ASSERT(prop != NULL);

	rc = ggiGAClearMotorProperties(prop);
	LIB_ASSERT(rc == GALLOC_OK);

	return rc;
}	/* ggiVideoClearMotorProperties */


int ggiVideoClearCarbProperties(struct ggiGA_resource_props *prop)
{
	int rc = GALLOC_OK;
	LIB_ASSERT(prop != NULL);

	rc = ggiGAClearCarbProperties(prop);
	LIB_ASSERT(rc == GALLOC_OK);

	return rc;
}	/* ggiVideoClearCarbProperties */


int ggiVideoClearTankProperties(struct ggiGA_resource_props *prop)
{
	int rc = GALLOC_OK;
	LIB_ASSERT(prop != NULL);

	rc = ggiGAClearTankProperties(prop);
	LIB_ASSERT(rc == GALLOC_OK);

	return rc;
}	/* ggiVideoClearTankProperties */




int ggiVideoSetCoordBase(ggiVideo_t video, unsigned int val)
{
	uint16 tmp;

	tmp = (val & GA_FLAG_COORDBASE_MASK);
	if (tmp == GA_COORDBASE_PIXELS || tmp == GA_COORDBASE_DOTS) {
		tmp |= (val & GA_FLAG_UNIT_MASK);
	}	/* if */

	if (tmp != val) return GALLOC_EFAILED;

	video->user_cb = tmp;

	return GALLOC_OK;
}	/* ggiVideoSetCoordBase */




int ggiVideoGetPos(ggiVideo_t video, long *x, long *y)
{
	*x = video->cur_x;
	*y = video->cur_y;

#warning convert *x and *y to the unit set in video->user_cb

	return GALLOC_OK;
}	/* ggiVideoGetPos */


int ggiVideoGetSize(ggivideo_t video, long *w, long *h)
{
	LIB_ASSERT(video != NULL);

	*w = video->cur_w;
	*h = video->cur_h;

#warning convert *w and *h to the unit set in video->user_cb

	return GALLOC_EFAILED;
}	/* ggiVideoGetSize */


int ggiVideoGetZoom(ggiVideo_t video, long *x, long *y, long *w, long *h)
{
	LIB_ASSERT(video != NULL);

	*x = video->cur_x;
	*y = video->cur_y;

	*w = video->cur_w;
	*h = video->cur_h;

#warning convert *x, *y, *w and *h to the unit set in video->user_cb

	return GALLOC_EFAILED;
}	/* ggiVideoGetZoom */


int ggiVideoGetPriority(ggiVideo_t video, uint32 *slot)
{
	LIB_ASSERT(video != NULL);
	LIB_ASSERT(slot != NULL);

	*slot = video->slot;

	return GALLOC_OK;
}	/* ggiVideoGetPriority */


enum ggiVideo_flags ggiVideoGetFlags(ggiVideo_t video)
{
	LIB_ASSERT(video != NULL);

	return (enum ggiVideo_flags)(video->flags);
}	/* ggiVideoGetFlags */



int ggiVideoIsVideoEmulated(ggiVideo_t video)
{
	LIB_ASSERT(video != NULL);

	return (video->vtype == VIDEO_EMUVIDEO) ? 1 : 0;
}	/* ggiVideoIsVideoEmulated */


int ggiVideoHideIfEmulated(ggiVideo_t video)
{
	LIB_ASSERT(video != NULL);

	if (ggiVideoIsVideoEmulated(video) {
		return ggiVideoHide(video);
	}	/* if */

	return GALLOC_OK;
}	/* ggiVideoHideIfEmulated */


int ggiVideoShowIfEmulated(ggiVideo_t video)
{
	LIB_ASSERT(video != NULL);

	if (ggiVideoIsVideoEmulated(video) {
		return ggiVideoShow(video);
	}	/* if */

	return GALLOC_OK;
}	/* ggiVideoShowIfEmulated */


int ggiVideoGetVideoProperties(ggiVideo_t video, struct gpf_fileinfo_t **info)
{
	if (video == NULL) return GGI_EARGINVAL;
	if (info == NULL) return GGI_EARGINVAL;
	if (info[0] != NULL) return GGI_EARGINVAL;

	return gpfGetFileInfo(video->gpf_handle, info);
}	/* ggiVideoGetVideoProperties */
