/*
******************************************************************************
 *
 * XMI pixel stubs - initialization.
 * 
 * Copyright (C) 2000 Jon M. Taylor
 *
******************************************************************************
*/

#include "stubsxmi.h"
#include "xmi_debug.h"

static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		   const char *args, void *argptr, uint32 *dlret)
{
	xmipriv *priv = LIBGGI_XMIEXT(vis);


	XMIDPRINT_CORE("GGIopen(%p, %p, %s, %p, %p) called for stubs sublib\n",
			vis, dlh, args ? args : "(NULL)", argptr, dlret);

	STUBSXMI_PRIV(vis) = malloc(sizeof(struct stubsxmi_priv));
	if (STUBSXMI_PRIV(vis) == NULL) {
		XMIDPRINT_CORE("Returning %i\n", GGI_ENOMEM);
		return GGI_ENOMEM;
	}

	priv->copypaintedsettovisual = XMI_stubs_copypaintedsettovisual;
	
	priv->newpaintedset = XMI_stubs_newpaintedset;
	priv->clearpaintedset = XMI_stubs_clearpaintedset;
	priv->deletepaintedset = XMI_stubs_deletepaintedset;
	
	priv->drawpoints = XMI_stubs_drawpoints;
	priv->drawlines = XMI_stubs_drawlines;
	priv->drawrectangles = XMI_stubs_drawrectangles;
	priv->drawarcs = XMI_stubs_drawarcs;
	
	priv->fillrectangles = XMI_stubs_fillrectangles;
	priv->fillpolygon = XMI_stubs_fillpolygon;
	priv->fillarcs = XMI_stubs_fillarcs;
	

	*dlret = (GGI_DL_EXTENSION | GGI_DL_OPDISPLAY);
	return 0;
}


static int GGIclose(ggi_visual *vis, struct ggi_dlhandle *dlh)
{
	XMIDPRINT_CORE("GGIclose(%p, %p) called for stubs sublib\n", vis, dlh);

#if 0
	/* FIXME: the access to STUBSXMI_PRIV(vis) segfaults */
	free(STUBSXMI_PRIV(vis));
	STUBSXMI_PRIV(vis) = NULL;
#endif

	return 0;
}

int GGIdl_stubs(int func, void **funcptr)
{
	XMIDPRINT_CORE("XMIdl_stubs() called\n");
	
	switch (func) {
	    case GGIFUNC_open:
		*funcptr = GGIopen;
		return 0;
	    case GGIFUNC_exit:
		*funcptr = NULL;
		return 0;
	    case GGIFUNC_close:
		*funcptr = GGIclose;
		return 0;
	    default:
		*funcptr = NULL;
	}
	
 	return GGI_ENOTFOUND;
}


/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
