/* This file defines the core libxmi API, consisting of:
 *
 * 1. miDrawPoints, miDrawLines, miFillPolygon.
 * 2. miDrawRectangles, miFillRectangles.
 * 3. miDrawArcs, miFillArcs.  Also the reentrant miDrawArcs_r.
 *
 * Each of these is a wrapper around an internal function that takes as first
 * argument a (miPaintedSet *).  A miPaintedSet struct is a structure that is
 * used by Joel McCormack's span-merging module to implement the
 * `touch-each-pixel-once' rule.  See mi_spans.c and mi_spans.h.
 */

#include "stubsxmi.h"
//#include "mi_spans.h"
//#include "mi_gc.h"
#include "mi_api.h"

#include "xmi_debug.h"

void XMI_stubs_drawarcs(ggi_visual_t vis, miPaintedSet *paintedSet, const miGC *pGC, int narcs, const miArc *parcs)
//void XMI_stubs_drawarcs(ggi_visual_t vis, const miGC *pGC, int narcs, const miArc *parcs)
{
	XMIDPRINT_CORE("XMI_stubs_drawarcs()\n");
	
	if (pGC->lineWidth == 0){
		/* use Bresenham algorithm */
		XMI_stubs_zeropolyarc(vis, paintedSet, pGC, narcs, parcs);
	}  else {
		XMI_stubs_polyarc(vis, paintedSet, pGC, narcs, parcs);
	}
}

void XMI_stubs_drawlines(ggi_visual_t vis, miPaintedSet *paintedSet, const miGC *pGC, miCoordMode mode, int npt, const miPoint *pPts)
//void XMI_stubs_drawlines(ggi_visual_t vis, const miGC *pGC, miCoordMode mode, int npt, const miPoint *pPts)
{
	XMIDPRINT_CORE("XMI_stubs_drawlines()\n");
	
	if (pGC->lineWidth == 0)
	{
		/* Use Bresenham algorithm */
		if (pGC->lineStyle == (int)MI_LINE_SOLID)
		  XMI_stubs_zeroline(vis, paintedSet, pGC, mode, npt, pPts);
		else
		  XMI_stubs_zerodash(vis, paintedSet, pGC, mode, npt, pPts);
	}
	else
	{
		if (pGC->lineStyle == (int)MI_LINE_SOLID)
		  XMI_stubs_wideline(vis, paintedSet, pGC, mode, npt, pPts);
		else
		  XMI_stubs_widedash(vis, paintedSet, pGC, mode, npt, pPts);
	}
}

void XMI_stubs_drawrectangles(ggi_visual_t vis, miPaintedSet *paintedSet, const miGC *pGC, int nrects, const miRectangle *prectInit)
//void XMI_stubs_drawrectangles(ggi_visual_t vis, const miGC *pGC, int nrects, const miRectangle *prectInit)
{
	const miRectangle *pR = prectInit;
	miPoint rect[5];
	int i;

	XMIDPRINT_CORE("XMI_stubs_drawrectangles()\n");
	
	for (i = 0; i < nrects; i++)
	{
		rect[0].x = pR->x;
		rect[0].y = pR->y;
		
		rect[1].x = pR->x + (int) pR->width;
		rect[1].y = rect[0].y;
		
		rect[2].x = rect[1].x;
		rect[2].y = pR->y + (int) pR->height;
		
		rect[3].x = rect[0].x;
		rect[3].y = rect[2].y;
		
		/* Close the polyline */
		rect[4].x = rect[0].x;
		rect[4].y = rect[0].y;
		
		XMI_stubs_drawlines(vis, paintedSet, pGC, MI_COORD_MODE_ORIGIN, 5, rect);
//		XMI_stubs_drawlines(vis, pGC, MI_COORD_MODE_ORIGIN, 5, rect);
		pR++;
	}
}
