#include "stubsxmi.h"
//#include "mi_spans.h"
//#include "mi_gc.h"
#include "mi_api.h"
#include "xmi_debug.h"

/* mi rectangles
 * written by Todd Newman, with debts to all and sundry
 */



void XMI_stubs_fillrectangle(ggi_visual_t vis, miPaintedSet *paintedSet,
				const miGC *pGC, const miRectangle *prect)
{
	miPoint *ppt;
	miPoint *pptFirst;
	int xorg, yorg;
	unsigned int *pw, *pwFirst;
	unsigned int height, width;
	unsigned int numSpans;
	Spans spanRec;
	

        /* Use ggiDrawBox() for possible acceleration
         * if no blend stages are active (solid-fill).
         */
        if (pGC->numInBlendStageList == 0) {

		ggi_pixel col = 0;

		XMIDPRINT_DRAW("Draw a XMI_stubs_fillrectangle() using ggiDrawBox\n");

		if (pGC->numPixels > 1) {
			col = pGC->pixels[1];
		}

		ggiSetGCForeground(vis, col);
		ggiDrawBox(vis, prect->x, prect->y, (int)prect->width, (int)prect->height);
	} else {

		height = prect->height;
		width = prect->width;
		pptFirst = (miPoint *)malloc(height * sizeof(miPoint));
		pwFirst = (unsigned int *)malloc(height * sizeof(unsigned int));
		ppt = pptFirst;
		pw = pwFirst;

		xorg = prect->x;
		yorg = prect->y;
		
		numSpans = height;
	    
		while (height--) {
			*pw++ = width;
			ppt->x = xorg;
			ppt->y = yorg;
			ppt++;
			yorg++;
		}

		MI_PAINT_SPANS(paintedSet, pGC->pixels[1], (unsigned int)numSpans, pptFirst, pwFirst);
	}
}


/* Very straightforward.  We let the low-level paint function invoked by
 * MI_PAINT_SPANS() worry about clipping to the destination.  The miGC
 * struct is unused.
 *
 * Note libxmi's convention: right edges and bottom edges of filled
 * polygons (including rectangles) are unpainted, so that adjacent polygons
 * will abut with no overlaps or gaps. */
void XMI_stubs_fillrectangles(ggi_visual_t vis, miPaintedSet *paintedSet, 
			      const miGC *pGC, int nrects, 
			      const miRectangle *prectInit)
{
	const miRectangle *prect = NULL;

	XMIDPRINT_CORE("XMI_stubs_fillrectangles(nrects = %i)\n", nrects);
	
	/* Ensure we have >= 1 rects to fill */
	if (nrects <= 0)
		return;

	prect = prectInit;
	while (nrects--) {
		XMI_stubs_fillrectangle(vis, paintedSet, pGC, prect++);
	}
}
