#include "stubsxmi.h"
//#include "mi_spans.h"
//#include "mi_gc.h"
#include "mi_api.h"
#include "xmi_debug.h"

/* This routine paints a set of points.  All painting goes through the
 * low-level MI_PAINT_SPANS() macro. */
void XMI_stubs_drawpoints(ggi_visual_t vis, miPaintedSet *paintedSet, const miGC *pGC, miCoordMode mode, int npt, const miPoint *pPts)
//void XMI_stubs_drawpoints(ggi_visual_t vis, const miGC *pGC, miCoordMode mode, int npt, const miPoint *pPts)
{
	unsigned int	*pwidthInit, *pwidth;
	int		i;
	miPoint 	*ppt = (miPoint *)NULL;

	XMIDPRINT_CORE("XMI_stubs_drawpoints()\n");
	
	/* Ensure we have >=1 points */
	if (npt <= 0)
	  return;

	ppt = (miPoint *)malloc (npt * sizeof(miPoint));
	if (mode == MI_COORD_MODE_PREVIOUS) { /* convert from relative to absolute coordinates */
		ppt[0] = pPts[0];
		for (i = 1; i < npt; i++) {
			ppt[i].x = ppt[i-1].x + pPts[i].x;
			ppt[i].y = ppt[i-1].y + pPts[i].y;	  
		}
	}
	else { /* Just copy */
		for (i = 0; i < npt; i++)
		  ppt[i] = pPts[i];
	}
	
	pwidthInit = (unsigned int *)malloc (npt * sizeof(unsigned int));
	pwidth = pwidthInit;
	for (i = 0; i < npt; i++)
	  *pwidth++ = 1;
	
	if (npt > 1)
	  XMI_stubs_quicksortspansy(vis, ppt, pwidthInit, npt);
	MI_PAINT_SPANS(paintedSet, pGC->pixels[1], npt, ppt, pwidthInit)
}

