#include "xmi_int.h"

/* Function prototypes */

xmifunc_copypaintedsettovisual		XMI_stubs_copypaintedsettovisual;

xmifunc_newpaintedset			XMI_stubs_newpaintedset;
xmifunc_clearpaintedset			XMI_stubs_clearpaintedset;
xmifunc_deletepaintedset		XMI_stubs_deletepaintedset;

xmifunc_drawpoints			XMI_stubs_drawpoints;
xmifunc_drawlines			XMI_stubs_drawlines;
xmifunc_drawrectangles			XMI_stubs_drawrectangles;
xmifunc_drawarcs			XMI_stubs_drawarcs;
xmifunc_fillrectangles			XMI_stubs_fillrectangles;
xmifunc_fillarcs			XMI_stubs_fillarcs;
xmifunc_fillpolygon			XMI_stubs_fillpolygon;

/* Structure holding private data. (of course, we don't need a private structure
   if it isn't used.  This is just here to show how to implement one.) */
struct stubsxmi_priv
{
	int   dummy1;
	long *dummyptr;
};

#define STUBSXMI_PRIV(vis) ((struct stubsxmi_priv*) (LIBGGI_XMIEXT(vis)->priv))

/**************************************************************************/
/* Define misc. math macros (in GCC, can be evaluated more rapidly).      */
/**************************************************************************/

#ifdef __GNUC__
#define DMAX(a,b) ({double _a = (a), _b = (b); _a > _b ? _a : _b; })
#define DMIN(a,b) ({double _a = (a), _b = (b); _a < _b ? _a : _b; })
#define IMAX(a,b) ({int _a = (a), _b = (b); _a > _b ? _a : _b; })
#define IMIN(a,b) ({int _a = (a), _b = (b); _a < _b ? _a : _b; })
#define UMAX(a,b) ({unsigned int _a = (a), _b = (b); _a > _b ? _a : _b; })
#define UMIN(a,b) ({unsigned int _a = (a), _b = (b); _a < _b ? _a : _b; })
#define IROUND(x) ({double _x = (x); int _i; \
                    if (_x >= INT_MAX) _i = INT_MAX; \
                    else if (_x <= -(INT_MAX)) _i = -(INT_MAX); \
                    else _i = (_x > 0.0 ? (int)(_x + 0.5) : (int)(_x - 0.5)); \
                    _i;})
#define FROUND(x) ({double _x = (x); float _f; \
                    if (_x >= FLT_MAX) _f = FLT_MAX; \
                    else if (_x <= -(FLT_MAX)) _f = -(FLT_MAX); \
                    else _f = _x; \
                    _f;})
#define FABS(x) ((x) >= 0.0 ? (x) : -(x))
#define ICEIL(x) ({double _x = (x); int _i = (int)_x; \
		   ((_x == _i) || (_x < 0.0)) ? _i : _i + 1;})
#define IFLOOR(x) ({double _x = (x); int _i = (int)_x; \
		   ((_x == _i) || (_x > 0.0)) ? _i : _i - 1;})
#else
#define DMAX(a,b) ((a) > (b) ? (a) : (b))
#define DMIN(a,b) ((a) < (b) ? (a) : (b))
#define IMAX(a,b) ((a) > (b) ? (a) : (b))
#define IMIN(a,b) ((a) < (b) ? (a) : (b))
#define UMAX(a,b) ((a) > (b) ? (a) : (b))
#define UMIN(a,b) ((a) < (b) ? (a) : (b))
#define IROUND(x) ((int) ((x) > 0 ? (x) + 0.5 : (x) - 0.5))
#define FROUND(x) ((float)(x))
#define FABS(x) ((x) >= 0.0 ? (x) : -(x))
#define ICEIL(x) ((int)ceil(x))
#define IFLOOR(x) ((int)floor(x))
#endif

