/*
******************************************************************************

   Mode management for display-X and display-Xlib.

   Copyright (C) 2000	 Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

/*
 * This file is included by Xlib/mode.c and X/mode.c
 * It contains the following common functions:
 *
 *   int XMI_X_getapi(ggi_visual *vis, int num, char *apiname, char *arguments);
 *   int XMI_X_setmode(ggi_visual *vis, ggi_mode *tm);
 */  


int XMI_X_getapi(ggi_visual *vis, int num, char *apiname, char *arguments)
{
	xmipriv *priv = LIBGGI_XMIEXT(vis);
	int rc;

	XMIDPRINT_CORE("XMI_X_getapi(%p, %i, %s, %s) is called\n",
			vis, num, apiname, arguments);


#ifdef GGI_X_TARGET
	/* Call the native getapi()
	 *
	 * Note: That if-statement is necessary to avoid an segfault.
	 *	 XXMI_PRIV(vis) is overwritten by GGIopen() in the
	 *	 default-stubs, which shouldn't be. The native one
	 *	 has to be called to reload some other libraries
	 *	 i.e. generic-linear-%d inside of libggi.
	 */
	if (XXMI_PRIV(vis)->getapi != NULL) {
		rc = XXMI_PRIV(vis)->getapi(vis, num, apiname, arguments);
		if (rc != 0) {
			return rc;
		}
	}
#endif


#ifdef GGI_XLIB_TARGET
	/* Call the native getapi()
	 *
	 * Note: That if-statement is necessary to avoid an segfault.
	 *	 XLIBXMI_PRIV(vis) is overwritten by GGIopen() in the
	 *	 default-stubs, which shouldn't be. The native one
	 *	 has to be called to reload some other libraries
	 *	 i.e. generic-linear-%d inside of libggi.
	 */
	if (XLIBXMI_PRIV(vis)->getapi != NULL) {
		rc = XLIBXMI_PRIV(vis)->getapi(vis, num, apiname, arguments);
		if (rc != 0) {
			return rc;
		}
	}


	/* I know, that this shouldn't be here, but
	 * a (design) bug in the extension makes this necessary
	 * to replace the default-stubs functions with our own...
	 */

	priv->fillpolygon = XMI_Xlib_fillpolygon;
	priv->fillarcs = XMI_Xlib_fillarcs;
#endif

	switch(num) {
		case 0:
#ifdef GGI_X_TARGET
			strcpy(apiname  ,"display-x");
#endif
#ifdef GGI_XLIB_TARGET
			strcpy(apiname  ,"display-xlib");
#endif
			strcpy(arguments,"");
			return 0;
		case 1: strcpy(apiname ,"generic-stubs");
			strcpy(arguments,"");
			return 0;
		case 2: strcpy(apiname ,"generic-color");
			strcpy(arguments,"");
			return 0;
#ifdef GGI_X_TARGET
                case 3:
			sprintf(apiname, "generic-linear-%d",  GT_SIZE(LIBGGI_MODE(vis)->graphtype));
			strcpy(arguments,"");
			return 0;
#endif /* GGI_X_TARGET */
	}

	return -1;
}


static int _GGIdomode(ggi_visual *vis)
{
	xmipriv *priv = LIBGGI_XMIEXT(vis);
	int err, id;
	char sugname[GGI_MAX_APILEN], args[GGI_MAX_APILEN];

	XMIDPRINT_CORE("_GGIdomode(%p) is called\n", vis);

	_ggiZapMode(vis, 0);

	for (id=1; 0 == XMI_X_getapi(vis,id,sugname,args); id++) {
		err = _ggiOpenDL(vis, sugname, args, NULL);
		if (err) {
#ifdef GGI_X_TARGET
			fprintf(stderr,
				"display-x-xmi: Can't open the %s (%s) library.\n",
				sugname, args);
#endif
#ifdef GGI_XLIB_TARGET
			fprintf(stderr, "display-xlib-xmi: Can't open the %s (%s) library.\n",
				sugname, args);
#endif
			/* In our special case, fail is always fatal. */
			return err;
		} else {
			XMIDPRINT("X: XMI_X_setmode: success in loading %s (%s)\n",
				       sugname, args);
		}
	}

#ifdef GGI_XLIB_TARGET
	priv->fillpolygon = XMI_Xlib_fillpolygon;
	priv->fillarcs = XMI_Xlib_fillarcs;
#endif

	ggiIndicateChange(vis, GGI_CHG_APILIST);

	return 0;
}



int XMI_X_setmode(ggi_visual *vis, ggi_mode *tm)
{
	int rc;

	XMIDPRINT_CORE("XMI_X_setmode(%p,%p) is called\n", vis, tm);


#ifdef GGI_X_TARGET
	/* Call the native setmode()
	 *
	 * Note: That if-statement is necessary to avoid an segfault.
	 *	 XXMI_PRIV(vis) is overwritten by GGIopen() in the
	 *	 default-stubs.
	 *
	 * Note: ggiSetMode() doesn't work at all. The pointer to the native
	 *	 setmode()-function is saved in XXMI_PRIV(vis)->setmode, but
	 *	 because of the (design) bug it is destroyed and set back to
	 *	 NULL by something...
	 */
	if (XXMI_PRIV(vis)->setmode != NULL) {
		rc = XXMI_PRIV(vis)->setmode(vis, tm);
		if (rc != 0) {
			return rc;
		}
	}
#endif


#ifdef GGI_XLIB_TARGET
	/* Call the native setmode()
	 *
	 * Note: That if-statement is necessary to avoid an segfault.
	 *	 XLIBXMI_PRIV(vis) is overwritten by GGIopen() in the
	 *	 default-stubs.
	 *
	 * Note: ggiSetMode() doesn't work at all. The pointer to the native
	 *	 setmode()-function is saved in XLIBXMI_PRIV(vis)->setmode, but
	 *	 because of the (design) bug it is destroyed and set back to
	 *	 NULL by something...
	 */
	if (XLIBXMI_PRIV(vis)->setmode != NULL) {
		rc = XLIBXMI_PRIV(vis)->setmode(vis, tm);
		if (rc != 0) {
			return rc;
		}
	}
#endif

	rc = _GGIdomode(vis);
	
	return rc;
}
