/*
******************************************************************************

   X-Target library for libXMI.

   Copyright (C) 2000      Christoph Egger      [Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/xcommon.h>
#include <ggi/display/xlib.h>

#include <X11/X.h>

#include "xlibxmi.h"
#include "xmi_debug.h"


/* _All_ non-local (ie not declared 'static') functions and variables _must_
   be prefixed with the extension name, and for sublibs also with a unique
   sublib identifier. This is to keep the namespace clean on systems where
   all symbols are exported by default.
*/



void XMI_Xlib_fillpolygon(ggi_visual_t vis, miPaintedSet *paintedSet,
				const miGC *pGC, miPolygonShape shape,
				miCoordMode mode, int npts, const miPoint *pPts)
{
	ggi_xwin_common *priv;
	XPoint *points = NULL;
	ggi_pixel col = 0;
	int i;


	XMIDPRINT_CORE("Xlib: XMI_Xlib_fillpolygon() called\n");
	XMIDPRINT_CORE("npts = %i\n", npts);

	priv = LIBGGI_PRIVATE(vis);

	points = malloc(sizeof(XPoint) * npts);


	for (i = 0; i < npts; i++) {	
		points[i].x = (short)pPts[i].x;
		points[i].y = (short)pPts[i].y;
	}

	if (pGC->numPixels > 0) {
		col = pGC->pixels[0];
	}


	switch (shape) {
	case MI_SHAPE_GENERAL:
		GGIDPRINT_CORE("shape = Complex\n");
		shape = Complex;	/* paths may intersect */
		break;

	case MI_SHAPE_CONVEX:
		GGIDPRINT_CORE("shape = Convex\n");
		shape = Convex;		/* wholly convex */
		break;
	}


	if (col != LIBGGI_GC(vis)->fg_color) {
		LIBGGI_GC(vis)->fg_color = col;
		XSetForeground(priv->x.display, priv->x.gc, col);
	}

	XFillPolygon(priv->x.display,
		priv->window,	/* drawable */
		priv->x.gc,
		points,		/* the array of points */
		npts,		/* number of points in the array */
		shape,
		mode);

	free(points);

	XLIB_DOSYNC(vis);

	return;
}


void XMI_Xlib_fillarc(ggi_visual_t vis, miPaintedSet *paintedSet, const miGC *pGC, const miArc *parc)
{
	ggi_xwin_common *priv;
	ggi_pixel col = 0;

	priv = LIBGGI_PRIVATE(vis);


	if (pGC->numPixels > 0) {
		col = pGC->pixels[0];
	}


	if (col != LIBGGI_GC(vis)->fg_color) {
		LIBGGI_GC(vis)->fg_color = col;
		XSetForeground(priv->x.display, priv->x.gc, col);
	}
	XFillArc(priv->x.display,
		priv->window,		/* drawable */
		priv->x.gc,
		parc->x, parc->y,
		parc->width, parc->height,
		parc->angle1, parc->angle2);

	XLIB_DOSYNC(vis);

	return;
}


void XMI_Xlib_fillarcs(ggi_visual_t vis, miPaintedSet *paintedSet, const miGC *pGC, int narcs, const miArc *parcs)
{
	int i;

	XMIDPRINT_CORE("XMI_X_fillarcs() called\n");

	for (i = 0; i < narcs; i++) {
		XMI_Xlib_fillarc(vis, paintedSet, pGC, &parcs[i]);
	}

	return;
}
