/*
******************************************************************************

   Copyright (C) 2000      Christoph Egger      [Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "xlibxmi.h"
#include "xmi_debug.h"
#include "xmi_int.h"


int XMI_X_getapi(ggi_visual *vis, int num, char *apiname, char *arguments);
int XMI_X_setmode(ggi_visual *vis, ggi_mode *tm);



static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		const char *args, void *argptr, uint32 *dlret)
{
	XMIDPRINT_CORE("GGIopen(%p, %p, %s, %p, %p) called for X-xmi sublib\n",
			vis, dlh, args ? args : "(NULL)", argptr, dlret);

	XLIBXMI_PRIV(vis) = malloc(sizeof(struct xlibxmi_priv));
	if (XLIBXMI_PRIV(vis) == NULL) {
		XMIDPRINT_CORE("Returning %i\n", GGI_ENOMEM);
		return GGI_ENOMEM;
	}

	/* used by XMI_X_setmode */
	XLIBXMI_PRIV(vis)->setmode = vis->opdisplay->setmode;
	XLIBXMI_PRIV(vis)->getapi = vis->opdisplay->getapi;

	vis->opdisplay->setmode = XMI_X_setmode;
	vis->opdisplay->getapi = XMI_X_getapi;


	*dlret = (GGI_DL_EXTENSION | GGI_DL_OPDISPLAY);
	return 0;
}


static int GGIclose(ggi_visual *vis, struct ggi_dlhandle *dlh)
{
	XMIDPRINT_CORE("GGIclose(%p, %p) called for X-xmi sublib\n",
		vis, dlh);

#if 0
	/* FIXME: the access to XLIBXMI_PRIV(vis) segfaults */

	vis->opdisplay->setmode = XLIBXMI_PRIV(vis)->setmode;
	vis->opdisplay->getapi = XLIBXMI_PRIV(vis)->getapi;

	free(XLIBXMI_PRIV(vis));
	XLIBXMI_PRIV(vis) = NULL;
#endif

	return 0;
}


int GGIdl_Xlib_xmi(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GGIopen;
		return 0;
	case GGIFUNC_exit:
		*funcptr = NULL;
		return 0;
        case GGIFUNC_close:
		*funcptr = GGIclose;
		return 0;
        default:
		*funcptr = NULL;
	 }

	return GGI_ENOTFOUND;
}


/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
