/*
******************************************************************************

   XMI extension initialization.

   Copyright (C) 2000		Jon Taylor	[taylorj@ggi-project.org]
   Copyright (C) 2000		Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <string.h>

#include "config.h"
#include "xmi_int.h"
#include "xmi_debug.h"

#include <ggi/gg.h>


#define GGI_SYMNAME_PREFIX  "GGIdl_"


/* Static variables 
 */
static int 	 _xmiLibIsUp       = 0;
static void	*_xmiConfigHandle  = NULL;
static char      _xmiconfstub[512] = XMICONFFILE;
static char     *_xmiconffile      = _xmiconfstub+XMITAGLEN;

int _xmiDebugSync = 0;
uint32 _xmiDebugState = 0;

/* Extension ID. Defaulting to -1 should make segfault on abuse more likely.
 * This is exported so that sublibs can use it. */
EXPORTVAR ggi_extid _xmiID = -1;




/* Dummy function which returns -1
 * We use this to reset the function pointers */
static int dummyfunc(void)
{
	XMIDPRINT_CORE("dummyfunc() called\n");

	return -1;
}

/* Reset all function pointers to dummyfunc */
static void clearfuncs(xmipriv *priv)
{
	XMIDPRINT_CORE("clearfuncs()\n");

#if 0
	priv->newgc = (void *)dummyfunc;
	priv->deletegc = (void *)dummyfunc;
	priv->copygc = (void *)dummyfunc;
	
	priv->setgcattrib = (void *)dummyfunc;
	priv->setgcattribs = (void *)dummyfunc;
	priv->setgcdashes = (void *)dummyfunc;
	priv->setgcmiterlimit = (void *)dummyfunc;
	priv->setgcpixels = (void *)dummyfunc;
	
	priv->newpaintedset = (void *)dummyfunc;
	priv->deletepaintedset = (void *)dummyfunc;
	
	priv->newcanvas = (void *)dummyfunc;
	priv->deletecanvas = (void *)dummyfunc;
	priv->copypaintedsettocanvas = (void *)dummyfunc;
#endif
	
	priv->drawpoints = (void *)dummyfunc;
	priv->drawlines = (void *)dummyfunc;
	priv->drawrectangles = (void *)dummyfunc;
	priv->drawarcs = (void *)dummyfunc;
	priv->fillrectangles = (void *)dummyfunc;
	priv->fillpolygon = (void *)dummyfunc;
	priv->fillarcs = (void *)dummyfunc;
}


/* This function is called by LibGGI when the API-list changes */
static int changed(ggi_visual_t vis, int whatchanged)
{
	XMIDPRINT_CORE("changed(%p, 0x%x)\n", vis, whatchanged);

	switch (whatchanged)  {
	case GGI_CHG_APILIST: 
		{
			int i;
			char api[GGI_MAX_APILEN], args[GGI_MAX_APILEN];
			const char *fname;
			ggi_dlhandle *lib;
			
			clearfuncs(LIBGGI_XMIEXT(vis));

			for (i = 0; ggiGetAPI(vis, i, api, args) == 0; i++) {
				strcat(api,"-xmi");
				XMIDPRINT_LIBS("Trying #%d: %s(%s) ...", i, api, args);

				fname = ggMatchConfig(_xmiConfigHandle, api, NULL);
				if (fname == NULL) {
					/* No special implementation for this sublib */
					continue;
				}
				lib = ggiExtensionLoadDL(vis, fname, args, NULL, GGI_SYMNAME_PREFIX);
			}
		}
		break;
	}
                                
	return 0;
}


/* Initialize the extension
 */
int xmiInit(void)
{
	int err;
	char *str;
	
	str = getenv("XMI_DEBUG");
	if (str != NULL) {
		_xmiDebugState = atoi(str);
		XMIDPRINT_CORE("Debugging=%d\n", _xmiDebugState);
	}
	
	str = getenv("XMI_DEBUGSYNC");
	if (str != NULL) {
		_xmiDebugSync = 1;
	}

	XMIDPRINT_CORE("xmiInit()\n");
	
	_xmiLibIsUp++;
	if (_xmiLibIsUp > 1) 
	  return 0; /* Initialize only at first call. */
		
	err = ggLoadConfig(_xmiconffile, &_xmiConfigHandle);
	if (err != GGI_OK) {
		fprintf(stderr,"LibXMI: couldn't open %s\n", _xmiconffile);
		_xmiLibIsUp--;
		return err;
	}

	_xmiID = ggiExtensionRegister("XMI", sizeof(xmipriv), changed);

	if (_xmiID < 0) {
		fprintf(stderr, "LibXMI: failed to register as extension.\n");
		_xmiLibIsUp--;
		ggFreeConfig(_xmiConfigHandle);
		return _xmiID;
	}

	return 0;
}


/* Deinitialize the extension */
int xmiExit(void)
{
	int rc;
    
	XMIDPRINT_CORE("xmiExit()\n");
	
	if (!_xmiLibIsUp) return -1;

	if (_xmiLibIsUp > 1) {
		/* Exit only at last call */
		_xmiLibIsUp--;
		return 0;
	}
	
	rc = ggiExtensionUnregister(_xmiID);
	ggFreeConfig(_xmiConfigHandle);

	_xmiLibIsUp = 0;

	return rc;
}


/* Attach the extension to a visual */
int xmiAttach(ggi_visual_t vis)
{
	int rc;

	XMIDPRINT_CORE("xmiAttach(%p) called\n", vis);

	rc = ggiExtensionAttach(vis, _xmiID);
	if (rc == 0) {
		/* We are actually creating the primary instance. */
		memset(LIBGGI_XMIEXT(vis), 0, sizeof(xmipriv));
		LIBGGI_XMIEXT(vis)->priv = NULL;

		/* Now fake an "API change" so the right libs get loaded */
		changed(vis, GGI_CHG_APILIST);
	}
	
	return rc;
}


/* Detach the extension from a visual */
int xmiDetach(ggi_visual_t vis)
{
	XMIDPRINT_CORE("xmiDetach(%p) called\n", vis);

	return ggiExtensionDetach(vis, _xmiID);
}

/* This should be included by exactly _one_ file in each extension library. */
#include <ggi/internal/ggilibinit.h>
