/* miPixmap stuff
 * 
 * Copyright 2000, Jon Taylor [taylorj@ggi-project.org]
 * 
 * *****************************************************
 * 
 * In X11, a pixmap is a simple offset into a physical region of memory,
 * with height, width and pixel type.  In GGI, things are more complicated,
 * due to the difference between using a DirectBuffer vs. ggiXYZ() API
 * calls to put/get pixels to and from the visual.  When a DB is available,
 * it is usually a lot faster to memcpy() between the source and destination
 * pixmaps, but we can always ggiGetPixel() if we have to.
 * 
 * TODO: Implement fast DB blitting.
 * 
 * TODO: Support attaching an miPixmap to an existing visual or directbuffer,
 * instead of always creating a new DB.
 */

#include "xmi_int.h"
#include "xmi_debug.h"

/* Create a new miPixmap */
miPixmap *miNewPixmap(uint w, uint h, ggi_graphtype type) {
	miPixmap *new_pPixmap;
	
	XMIDPRINT_CORE("miNewPixmap()\n");
	
	new_pPixmap = (miPixmap *)malloc(sizeof(miPixmap));
	
	new_pPixmap->vis = ggiOpen("memory");
	ggiSetSimpleMode(new_pPixmap->vis, w, h, 1, type);

	new_pPixmap->rect.x = 0;
	new_pPixmap->rect.y = 0;
	new_pPixmap->rect.width = w;
	new_pPixmap->rect.height = h;
	
	return new_pPixmap;
}

/* Destroy (deallocate) an miPixmap */
void miDeletePixmap(ggi_visual_t vis, miPixmap *pPixmap) {
	XMIDPRINT_CORE("XMI_stubs_deletepixmap()\n");

	ggiClose(pPixmap->vis);	
	free(pPixmap);
}
