/* $Id: xmi_debug.h,v 1.1.1.1 2001/04/21 16:56:10 cegger Exp $
******************************************************************************

   XMI debugging macros

   Copyright (C) 2000 Jon Taylor       	[taylorj@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _XMI_INTERNAL_DEBUG_H
#define _XMI_INTERNAL_DEBUG_H

#include <stdio.h>
#include <stdarg.h>
#include <ggi/types.h>
#include <ggi/gg.h>
#include "xmi.h"


__BEGIN_DECLS

/* Exported variables */
#ifdef BUILDING_XMI
extern uint32     _xmiDebugState;
extern int        _xmiDebugSync;
#else
IMPORTVAR uint32  _xmiDebugState;
IMPORTVAR int     _xmiDebugSync;
#endif
__END_DECLS


/* Debugging types
 * bit 0 is reserved! */

#define XMIDEBUG_CORE		(1<<1)	/*   2 */
#define XMIDEBUG_MODE		(1<<2)	/*   4 */
#define XMIDEBUG_COLOR		(1<<3)	/*   8 */
#define XMIDEBUG_DRAW		(1<<4)	/*  16 */
#define XMIDEBUG_MISC		(1<<5)	/*  32 */
#define XMIDEBUG_LIBS		(1<<6)	/*  64 */
#define XMIDEBUG_EVENTS		(1<<7)	/* 128 */

#define XMIDEBUG_ALL	0xffffffff

#ifdef __GNUC__

#ifdef DEBUG
#define XMIDPRINT(form,args...)	   if (_xmiDebugState) { ggDPrintf(_xmiDebugSync, "LibXMI",form, ##args); }
#define XMIDPRINT_CORE(form,args...)   if (_xmiDebugState & XMIDEBUG_CORE) { ggDPrintf(_xmiDebugSync,"LibXMI",form, ##args); }
#define XMIDPRINT_MODE(form,args...)   if (_xmiDebugState & XMIDEBUG_MODE) { ggDPrintf(_xmiDebugSync,"LibXMI",form, ##args); }
#define XMIDPRINT_COLOR(form,args...)  if (_xmiDebugState & XMIDEBUG_COLOR) { ggDPrintf(_xmiDebugSync,"LibXMI",form, ##args); }
#define XMIDPRINT_DRAW(form,args...)   if (_xmiDebugState & XMIDEBUG_DRAW) { ggDPrintf(_xmiDebugSync,"LibXMI",form, ##args); }
#define XMIDPRINT_MISC(form,args...)   if (_xmiDebugState & XMIDEBUG_MISC) { ggDPrintf(_xmiDebugSync,"LibXMI",form, ##args); }
#define XMIDPRINT_LIBS(form,args...)   if (_xmiDebugState & XMIDEBUG_LIBS) { ggDPrintf(_xmiDebugSync,"LibXMI",form, ##args); }
#define XMIDPRINT_EVENTS(form,args...) if (_xmiDebugState & XMIDEBUG_EVENTS) { ggDPrintf(_xmiDebugSync,"LibXMI",form, ##args); }
#else /* DEBUG */
#define XMIDPRINT(form,args...)		do{}while(0)
#define XMIDPRINT_CORE(form,args...)	do{}while(0)
#define XMIDPRINT_MODE(form,args...)	do{}while(0)
#define XMIDPRINT_COLOR(form,args...)	do{}while(0)
#define XMIDPRINT_DRAW(form,args...)	do{}while(0)
#define XMIDPRINT_MISC(form,args...)	do{}while(0)
#define XMIDPRINT_LIBS(form,args...)	do{}while(0)
#define XMIDPRINT_EVENTS(form,args...)	do{}while(0)
#endif /* DEBUG */

#else /* __GNUC__ */

__BEGIN_DECLS

static inline void XMIDPRINT(const char *form,...)
{
#ifdef DEBUG
	if (_xmiDebugState) {
		va_list args;

		fprintf(stderr, "XMI: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_xmiDebugSync) fflush(stderr);
	}
#endif
}

static inline void XMIDPRINT_CORE(const char *form,...)
{
#ifdef DEBUG
	if (_xmiDebugState & XMIDEBUG_CORE) {
		va_list args;

		fprintf(stderr, "XMI: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_xmiDebugSync) fflush(stderr);
	}
#endif
}

static inline void XMIDPRINT_MODE(const char *form,...)
{
#ifdef DEBUG
	if (_xmiDebugState & XMIDEBUG_MODE) {
		va_list args;

		fprintf(stderr, "XMI: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_xmiDebugSync) fflush(stderr);
	}
#endif
}

static inline void XMIDPRINT_COLOR(const char *form,...)
{
#ifdef DEBUG
	if (_xmiDebugState & XMIDEBUG_COLOR) {
		va_list args;

		fprintf(stderr, "XMI: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_xmiDebugSync) fflush(stderr);
	}
#endif
}

static inline void XMIDPRINT_DRAW(const char *form,...)
{
#ifdef DEBUG
	if (_xmiDebugState & XMIDEBUG_DRAW) {
		va_list args;

		fprintf(stderr, "XMI: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_xmiDebugSync) fflush(stderr);
	}
#endif
}

static inline void XMIDPRINT_MISC(const char *form,...)
{
#ifdef DEBUG
	if (_xmiDebugState & XMIDEBUG_MISC) {
		va_list args;

		fprintf(stderr, "XMI: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_xmiDebugSync) fflush(stderr);
	}
#endif
}

static inline void XMIDPRINT_LIBS(const char *form,...)
{
#ifdef DEBUG
	if (_xmiDebugState & XMIDEBUG_LIBS) {
		va_list args;

		fprintf(stderr, "XMI: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_xmiDebugSync) fflush(stderr);
	}
#endif
}

static inline void XMIDPRINT_EVENTS(const char *form,...)
{
#ifdef DEBUG
	if (_xmiDebugState & XMIDEBUG_EVENTS) {
		va_list args;

		fprintf(stderr, "XMI: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_xmiDebugSync) fflush(stderr);
	}
#endif
}

__END_DECLS

#endif /* __GNUC__ */

#ifdef DEBUG
#define XMI_ASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"XMI:%s:%d: INTERNAL ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#define XMI_APPASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"XMI:%s:%d: APPLICATION ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#else /* DEBUG */
#define XMI_ASSERT(x,str)	do{}while(0)
#define XMI_APPASSERT(x,str)	do{}while(0)
#endif /* DEBUG */

#ifdef DEBUG
# define XMID0(x)	x
#else
# define XMID0(x)	/* empty */
#endif

#ifdef XMIDLEV
# if XMIDLEV == 1
#  define XMID1(x)	x
#  define XMID2(x)	/* empty */
#  define XMID3(x)	/* empty */
# elif XMIDLEV == 2
#  define XMID1(x)	x
#  define XMID2(x)	x
#  define XMID3(x)	/* empty */
# elif XMIDLEV > 2
#  define XMID1(x)	x
#  define XMID2(x)	x
#  define XMID3(x)	x
# endif
#else
# define XMID1(x)	/* empty */
# define XMID2(x)	/* empty */
# define XMID3(x)	/* empty */
#endif

#endif /* _XMI_INTERNAL_DEBUG_H */
