/*
******************************************************************************
 * 
 *  XMI extension internals
 * 
 *  Copyright 2000, Jon Taylor
 *
******************************************************************************
*/

#ifndef _GGI_XMI_INT_H
#define _GGI_XMI_INT_H

#include <ggi/internal/internal.h>
#include "xmi.h"

__BEGIN_DECLS

/* Exported variables */
#ifdef BUILDING_LIBXMI
extern ggi_extid    _xmiID;
#else
IMPORTVAR ggi_extid _xmiID;
#endif

__END_DECLS

/* Data types for the API functions */
  
typedef void (xmifunc_setgcattrib)(ggi_visual *vis, miGC *pGC, miGCAttribute attribute, int value);
typedef void (xmifunc_setgcattribs)(ggi_visual *vis, miGC *pGC, int nattributes, const miGCAttribute *attribute, const int *values);
typedef void (xmifunc_setgcdashes)(ggi_visual_t vis, miGC *pGC, int ndashes, const unsigned int *dashes, int offset);
typedef void (xmifunc_setgcmiterlimit)(ggi_visual_t vis, miGC *pGC, double value);
typedef void (xmifunc_setgcpixels)(ggi_visual_t vis, miGC *pGC, int npixels, const miPixel *pixels);
typedef void (xmifunc_setgcblendstages)(ggi_visual_t vis, miGC *pGC, int nstages, const miBlendStage *blendstages);

typedef miPaintedSet * (xmifunc_newpaintedset)(ggi_visual_t vis);
typedef void (xmifunc_clearpaintedset)(ggi_visual_t vis, miPaintedSet *paintedSet);
typedef void (xmifunc_deletepaintedset)(ggi_visual_t vis, miPaintedSet *paintedSet);

typedef void (xmifunc_drawpoints)(ggi_visual_t vis, miPaintedSet *paintedSet, const miGC *pGC, miCoordMode mode, int npts, const miPoint *pPts);
typedef void (xmifunc_drawlines)(ggi_visual_t vis, miPaintedSet *paintedSet, const miGC *pGC, miCoordMode mode, int npts, const miPoint *pPts);
typedef void (xmifunc_drawrectangles)(ggi_visual_t vis, miPaintedSet *paintedSet, const miGC *pGC, int nrects, const miRectangle *prects);
typedef void (xmifunc_drawarcs)(ggi_visual_t vis, miPaintedSet *paintedSet, const miGC *pGC, int narcs, const miArc *parcs);
typedef void (xmifunc_fillrectangles)(ggi_visual_t vis, miPaintedSet *paintedSet, const miGC *pGC, int nrects, const miRectangle *prects);
typedef void (xmifunc_fillpolygon)(ggi_visual_t vis, miPaintedSet *paintedSet, const miGC *pGC, miPolygonShape shape, miCoordMode mode, int npts, const miPoint *pPts);
typedef void (xmifunc_fillarcs)(ggi_visual_t vis, miPaintedSet *paintedSet, const miGC *pGC, int narcs, const miArc *parcs);

typedef void (xmifunc_copypaintedsettovisual)(ggi_visual_t vis, const miGC *pGC, const miPaintedSet *paintedSet, miPoint origin);

/* Visual private data for LibXMI.  A lot of state-related stuff floating around
 * out there in the rest of the XMI source tree will eventually migrate here. */
typedef struct xmipriv 
{
	xmifunc_newpaintedset	       	*newpaintedset;
	xmifunc_deletepaintedset       	*deletepaintedset;
	xmifunc_clearpaintedset		*clearpaintedset;
	
	xmifunc_copypaintedsettovisual	*copypaintedsettovisual;
	
	xmifunc_drawpoints		*drawpoints;
	xmifunc_drawlines	       	*drawlines;
	xmifunc_drawrectangles		*drawrectangles;
	xmifunc_drawarcs	       	*drawarcs;
	
	xmifunc_fillrectangles		*fillrectangles;	
	xmifunc_fillpolygon	       	*fillpolygon;
	xmifunc_fillarcs	       	*fillarcs;
		
	void *priv;	/* Here sublibs can store visual specific private data.
			   If you have more than one sublib (for each visual)
			   that needs private data, just add more pointers or
			   add the data fields directly in this structure. */
} xmipriv;


/* Used to access the xmipriv structure for a particular visual. */
#define LIBGGI_XMIEXT(vis) ((xmipriv *)LIBGGI_EXT((vis),_xmiID))

#endif /* _GGI_XMI_INT_H */
