/* $Id: init.c,v 1.3 2002/09/15 10:55:53 cegger Exp $
******************************************************************************

   Wmh extension initialization.

   Copyright (C) 1999 Andreas Beck	[becka@ggi-project.org]
   Copyright (C) 1999 Marcus Sundberg	[marcus@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <string.h>

#include "config.h"
#include "wmh_int.h"

#define GGI_SYMNAME_PREFIX  "GGIdl_"

/* Static variables 
 */

static int 	 _ggiwmhLibIsUp=0;
static void	*_ggiwmhConfigHandle;
static char      ggiwmhconfstub[512]=GGIWMHCONFFILE;
static char     *ggiwmhconffile=ggiwmhconfstub+GGIWMHTAGLEN;

/* Extension ID. Defaulting to -1 should make segfault on abuse more likely...
 */
EXPORTVAR ggi_extid ggiWmhID = -1;


static int dummyfunc(void) { return -1; }

static void clearfuncs(ggiwmhext *ext)
{
	ext->move		= (void *) dummyfunc;
	ext->resize		= (void *) dummyfunc;
	ext->getpos		= (void *) dummyfunc;
	ext->getsize		= (void *) dummyfunc;
	ext->maximize		= (void *) dummyfunc;
	ext->moveicon		= (void *) dummyfunc;
	ext->settitle		= (void *) dummyfunc;
	ext->seticontitle	= (void *) dummyfunc;
	ext->zorder		= (void *) dummyfunc;
	ext->iconify		= (void *) dummyfunc;
	ext->allowresize	= (void *) dummyfunc;
}

static int changed(ggi_visual_t vis,int whatchanged)
{
	GGIDPRINT("changed(%p, %i) called for misc extension\n",
		  vis, whatchanged);

	switch(whatchanged) {
		case GGI_CHG_APILIST: {
			int temp;
			char api[256], args[256];
			const char *fname;
			ggi_dlhandle *lib;

			GGIDPRINT("changed() APILIST \n");
			
			clearfuncs(LIBGGI_WMHEXT(vis));
			for(temp=0; ggiGetAPI(vis, temp, api, args) == 0; temp++) {
				strcat(api,"-wmh");
				GGIDPRINT("Trying #%d: %s(%s)\n",
					  temp, api, args);
				fname = ggMatchConfig(_ggiwmhConfigHandle, api, NULL);
			
				if (fname == NULL) {
					/* No special implementation for this sublib */
					continue;
				}
				lib = ggiExtensionLoadDL(vis, fname, args, NULL, GGI_SYMNAME_PREFIX);
			}
		}
		break;
	}
                                
	return 0;
}

int ggiWmhInit(void)
{
	int err;

	_ggiwmhLibIsUp++;
	if (_ggiwmhLibIsUp > 1) return 0; /* Initialize only at first call. */

	err = ggLoadConfig(ggiwmhconffile, &_ggiwmhConfigHandle);
	if (err != GGI_OK) {
		fprintf(stderr,"LibGGIWMH: couldn't open %s\n",
			ggiwmhconffile);
		_ggiwmhLibIsUp--;
		return err;
	}

	ggiWmhID = ggiExtensionRegister("GGIWMH", sizeof(struct wmh_ext),
					changed);

	if (ggiWmhID < 0) {
		fprintf(stderr,
			"LibGGIWMH: failed to register as extension.\n");
		_ggiwmhLibIsUp--;
		ggFreeConfig(_ggiwmhConfigHandle);
		return ggiWmhID;
	}

	return 0;
}

int ggiWmhExit(void)
{
	int rc;
    
	if (!_ggiwmhLibIsUp) return -1;

	if (_ggiwmhLibIsUp > 1) {
		/* Exit only at last call */
		_ggiwmhLibIsUp--;
		return 0;
	}
	
	rc = ggiExtensionUnregister(ggiWmhID);
	ggFreeConfig(_ggiwmhConfigHandle);

	_ggiwmhLibIsUp = 0;

	return rc;
}

int ggiWmhAttach(ggi_visual_t vis)
{
	int rc;

	rc = ggiExtensionAttach(vis, ggiWmhID);
	if (rc == 0) {
		/* We are actually creating the primary instance. */
		memset(LIBGGI_WMHEXT(vis), 0, sizeof(ggiwmhext));
                        
		/* Now fake an "API change" so the right libs get loaded */
		changed(vis, GGI_CHG_APILIST);
	}

	return rc;
}

int ggiWmhDetach(ggi_visual_t vis)
{
	return ggiExtensionDetach(vis, ggiWmhID);
}

