/*
******************************************************************************

   Generic color default library implementation

   Copyright (C) 2000-2001 Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/


#include <stdlib.h>

#include "color.h"



/* Color palette manipulation
 */

/* RGBA */
gcp_pixel GGI_color_MapRGBAColor(ggi_visual_t vis, gcp_RGBAcolor *col)
{
	return ggiMapColor(vis, col);
}	/* GGI_color_MapRGBAColor */


int GGI_color_UnmapRGBAPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_RGBAcolor *col)
{
	return ggiUnmapPixel(vis, pixel, col);
}	/* GGI_color_UnmapRGGAPixel */


int GGI_color_PackRGBAColors(ggi_visual_t vis,void *buf,gcp_RGBAcolor *cols,int len)
{
	return ggiPackColors(vis, buf, cols, len);
}	/* GGI_color_PackRGBAColors */


int GGI_color_UnpackRGBAPixels(ggi_visual_t vis,void *buf,gcp_RGBAcolor *cols,int len)
{
	return ggiUnpackPixels(vis, buf, cols, len);
}	/* GGI_color_UnpackRGBA_Pixels */


int GGI_color_GetRGBAPalette(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *cmap)
{
	return ggiGetPalette(vis, s, len, cmap);
}	/* GGI_color_GetRGBAPalette */


int GGI_color_SetRGBAPalette(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *cmap)
{
	return ggiSetPalette(vis, s, len, cmap);
}	/* GGI_color_SetRGBAPalette */





/* YUV */
gcp_pixel GGI_color_MapYUVColor(ggi_visual_t vis, gcp_YUVcolor *col)
{
	int rc = 0;
	gcp_RGBAcolor rgba;

	rc = gcpYUV2RGBA(vis, col, &rgba);
	LIB_ASSERT(rc == 0);

	return gcpMapRGBAColor(vis, &rgba);
}	/* GGI_color_MapYUVColor */


int GGI_color_UnmapYUVPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_YUVcolor *col)
{
	int rc = 0;
	gcp_RGBAcolor rgba;

	rc = gcpUnmapRGBAPixel(vis, pixel, &rgba);
	LIB_ASSERT(rc == 0);

	return gcpRGBA2YUV(vis, &rgba, col);
}	/* GGI_color_UnmapYUVPixel */


int GGI_color_PackYUVColors(ggi_visual_t vis,void *buf,gcp_YUVcolor *cols,int len)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	for (i = 0; i < len; i++) {
		rc = gcpYUV2RGBA(vis, &cols[i], &rgba[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */

	rc = ggiPackColors(vis, buf, rgba, len);

	free(rgba);

	return rc;
}	/* GGI_color_PackYUVColors */


int GGI_color_UnpackYUVPixels(ggi_visual_t vis,void *buf,gcp_YUVcolor *cols,int len)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	rc = ggiUnpackPixels(vis, buf, rgba, len);
	if (rc != 0) goto err0;

	for (i = 0; i < len; i++) {
		rc = gcpRGBA2YUV(vis, &rgba[i], &cols[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */


err0:
	free(rgba);

	return rc;
}	/* GGI_color_UnpackYUVPixels */


int GGI_color_GetYUVPalette(ggi_visual_t vis,int s,int len,gcp_YUVcolor *cmap)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	rc = ggiGetPalette(vis, s, len, rgba);
	if (rc != 0) goto err0;

	for (i = 0; i < len; i++) {
		rc = gcpRGBA2YUV(vis, &rgba[i], &cmap[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */


err0:
	free(rgba);

	return rc;
}	/* GGI_color_GetYUVPalette */


int GGI_color_SetYUVPalette(ggi_visual_t vis,int s,int len,gcp_YUVcolor *cmap)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	for (i = 0; i < len; i++) {
		rc = gcpYUV2RGBA(vis, &cmap[i], &rgba[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */


	rc = ggiSetPalette(vis, s, len, rgba);

	free(rgba);

	return rc;
}	/* GGI_color_SetYUVPalette */





/* CMYK */
gcp_pixel GGI_color_MapCMYKColor(ggi_visual_t vis, gcp_CMYKcolor *col)
{
	int rc = 0;
	gcp_RGBAcolor rgba;

	rc = gcpCMYK2RGBA(vis, col, &rgba);
	LIB_ASSERT(rc == 0);

	return gcpMapRGBAColor(vis, &rgba);
}	/* GGI_color_MapCMYKColor */


int GGI_color_UnmapCMYKPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_CMYKcolor *col)
{
	int rc = 0;
	gcp_RGBAcolor rgba;

	rc = gcpUnmapRGBAPixel(vis, pixel, &rgba);
	LIB_ASSERT(rc == 0);

	return gcpRGBA2CMYK(vis, &rgba, col);
}	/* GGI_color_UnmapCMYKPixel */


int GGI_color_PackCMYKColors(ggi_visual_t vis,void *buf,gcp_CMYKcolor *cols,int len)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	for (i = 0; i < len; i++) {
		rc = gcpCMYK2RGBA(vis, &cols[i], &rgba[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */

	rc = ggiPackColors(vis, buf, rgba, len);

	free(rgba);

	return rc;
}	/* GGI_color_PackCMYKColors */


int GGI_color_UnpackCMYKPixels(ggi_visual_t vis,void *buf,gcp_CMYKcolor *cols,int len)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	rc = ggiUnpackPixels(vis, buf, rgba, len);
	if (rc != 0) goto err0;

	for (i = 0; i < len; i++) {
		rc = gcpRGBA2CMYK(vis, &rgba[i], &cols[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */


err0:
	free(rgba);

	return rc;
}	/* GGI_color_UnpackCMYKPixels */


int GGI_color_GetCMYKPalette(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *cmap)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	rc = ggiGetPalette(vis, s, len, rgba);
	if (rc != 0) goto err0;

	for (i = 0; i < len; i++) {
		rc = gcpRGBA2CMYK(vis, &rgba[i], &cmap[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */


err0:
	free(rgba);

	return rc;
}	/* GGI_color_GetCMYKPalette */


int GGI_color_SetCMYKPalette(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *cmap)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	for (i = 0; i < len; i++) {
		rc = gcpCMYK2RGBA(vis, &cmap[i], &rgba[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */


	rc = ggiSetPalette(vis, s, len, rgba);

	free(rgba);

	return rc;
}	/* GGI_color_SetCMYKPalette */





/* HSV */
gcp_pixel GGI_color_MapHSVColor(ggi_visual_t vis, gcp_HSVcolor *col)
{
	int rc = 0;
	gcp_RGBAcolor rgba;

	rc = gcpHSV2RGBA(vis, col, &rgba);
	LIB_ASSERT(rc == 0);

	return gcpMapRGBAColor(vis, &rgba);
}	/* GGI_color_MapHSVColor */


int GGI_color_UnmapHSVPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_HSVcolor *col)
{
	int rc = 0;
	gcp_RGBAcolor rgba;

	rc = gcpUnmapRGBAPixel(vis, pixel, &rgba);
	LIB_ASSERT(rc == 0);

	return gcpRGBA2HSV(vis, &rgba, col);
}	/* GGI_color_UnmapHSVPixel */


int GGI_color_PackHSVColors(ggi_visual_t vis,void *buf,gcp_HSVcolor *cols,int len)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	for (i = 0; i < len; i++) {
		rc = gcpHSV2RGBA(vis, &cols[i], &rgba[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */

	rc = ggiPackColors(vis, buf, rgba, len);

	free(rgba);

	return rc;
}	/* GGI_color_PackHSVColors */


int GGI_color_UnpackHSVPixels(ggi_visual_t vis,void *buf,gcp_HSVcolor *cols,int len)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	rc = ggiUnpackPixels(vis, buf, rgba, len);
	if (rc != 0) goto err0;

	for (i = 0; i < len; i++) {
		rc = gcpRGBA2HSV(vis, &rgba[i], &cols[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */


err0:
	free(rgba);

	return rc;
}	/* GGI_color_UnpackHSVPixels */


int GGI_color_GetHSVPalette(ggi_visual_t vis,int s,int len,gcp_HSVcolor *cmap)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	rc = ggiGetPalette(vis, s, len, rgba);
	if (rc != 0) goto err0;

	for (i = 0; i < len; i++) {
		rc = gcpRGBA2HSV(vis, &rgba[i], &cmap[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */


err0:
	free(rgba);

	return rc;
}	/* GGI_color_GetHSVPalette */


int GGI_color_SetHSVPalette(ggi_visual_t vis,int s,int len,gcp_HSVcolor *cmap)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	for (i = 0; i < len; i++) {
		rc = gcpHSV2RGBA(vis, &cmap[i], &rgba[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */


	rc = ggiSetPalette(vis, s, len, rgba);

	free(rgba);

	return rc;
}	/* GGI_color_SetHSVPalette */



/* Kodak PhotoCD */
gcp_pixel GGI_color_MapYCCColor(ggi_visual_t vis, gcp_YCCcolor *col)
{
	int rc = 0;
	gcp_RGBAcolor rgba;

	rc = gcpYCC2RGBA(vis, col, &rgba);
	LIB_ASSERT(rc == 0);

	return gcpMapRGBAColor(vis, &rgba);
}	/* GGI_color_MapYCCColor */


int GGI_color_UnmapYCCPixel(ggi_visual_t vis, gcp_pixel pixel, gcp_YCCcolor *col)
{
	int rc = 0;
	gcp_RGBAcolor rgba;

	rc = gcpUnmapRGBAPixel(vis, pixel, &rgba);
	LIB_ASSERT(rc == 0);

	return gcpRGBA2YCC(vis, &rgba, col);
}	/* GGI_color_UnmapYCCPixel */


int GGI_color_PackYCCColors(ggi_visual_t vis,void *buf,gcp_YCCcolor *cols,int len)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	for (i = 0; i < len; i++) {
		rc = gcpYCC2RGBA(vis, &cols[i], &rgba[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */

	rc = ggiPackColors(vis, buf, rgba, len);

	free(rgba);

	return rc;
}	/* GGI_color_PackYCCColors */


int GGI_color_UnpackYCCPixels(ggi_visual_t vis,void *buf,gcp_YCCcolor *cols,int len)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	rc = ggiUnpackPixels(vis, buf, rgba, len);
	if (rc != 0) goto err0;

	for (i = 0; i < len; i++) {
		rc = gcpRGBA2YCC(vis, &rgba[i], &cols[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */


err0:
	free(rgba);

	return rc;
}	/* GGI_color_UnpackYCCPixels */


int GGI_color_GetYCCPalette(ggi_visual_t vis,int s,int len,gcp_YCCcolor *cmap)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	rc = ggiGetPalette(vis, s, len, rgba);
	if (rc != 0) goto err0;

	for (i = 0; i < len; i++) {
		rc = gcpRGBA2YCC(vis, &rgba[i], &cmap[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */


err0:
	free(rgba);

	return rc;
}	/* GGI_color_GetYCCPalette */


int GGI_color_SetYCCPalette(ggi_visual_t vis,int s,int len,gcp_YCCcolor *cmap)
{
	int rc = 0;
	int i;
	gcp_RGBAcolor *rgba;

	rgba = malloc(sizeof(gcp_RGBAcolor) * len);
	if (!rgba) return GGI_ENOMEM;

	for (i = 0; i < len; i++) {
		rc = gcpYCC2RGBA(vis, &cmap[i], &rgba[i]);
		LIB_ASSERT(rc == 0);
	}	/* while */


	rc = ggiSetPalette(vis, s, len, rgba);

	free(rgba);

	return rc;
}	/* GGI_color_SetYCCPalette */

