/*
******************************************************************************

   LIBGCP debugging macros

   Copyright (C) 2000-2001 Christoph Egger	[Christoph_Egger@t-online.de]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GCP_INTERNAL_DEBUG_H
#define _GCP_INTERNAL_DEBUG_H

#include <stdio.h>
#include <stdarg.h>
#include <ggi/types.h>
#include <ggi/gg.h>


__BEGIN_DECLS

/* Exported variables */
#ifdef BUILDING_LIBGCP
extern uint32     _gcpDebugState;
extern int        _gcpDebugSync;
#else
IMPORTVAR uint32  _gcpDebugState;
IMPORTVAR int     _gcpDebugSync;
#endif
__END_DECLS


/* Debugging types
 * bit 0 is reserved! */

#define GCPDEBUG_CORE		(1<<1)	/*   2 */
#define GCPDEBUG_MODE		(1<<2)	/*   4 */
#define GCPDEBUG_COLOR		(1<<3)	/*   8 */
#define GCPDEBUG_DRAW		(1<<4)	/*  16 */
#define GCPDEBUG_MISC		(1<<5)	/*  32 */
#define GCPDEBUG_LIBS		(1<<6)	/*  64 */
#define GCPDEBUG_EVENTS		(1<<7)	/* 128 */

#define GCPDEBUG_ALL	0xffffffff

#define DEBUG_INFO      __FILE__,__PRETTY_FUNCTION__,__LINE__

#ifdef DEBUG
#define LIB_ASSERT(x)   if (x) {} else { ggDPrintf(_gcpDebugSync, "LIBGCP", "%s %s %s assertion \"%s\" failed.\n", __FILE__, __LINE__, __PRETTY_FUNCTION__ #x); }
#else
#define LIB_ASSERT(x)   do{}while(0)
#endif



#ifdef __GNUC__

#ifdef DEBUG
#define GCPDPRINT(form,args...)	   if (_gcpDebugState) { ggDPrintf(_gcpDebugSync, "LibGCP",form, ##args); }
#define GCPDPRINT_CORE(form,args...)   if (_gcpDebugState & GCPDEBUG_CORE) { ggDPrintf(_gcpDebugSync,"LibGCP",form, ##args); }
#define GCPDPRINT_MODE(form,args...)   if (_gcpDebugState & GCPDEBUG_MODE) { ggDPrintf(_gcpDebugSync,"LibGCP",form, ##args); }
#define GCPDPRINT_COLOR(form,args...)  if (_gcpDebugState & GCPDEBUG_COLOR) { ggDPrintf(_gcpDebugSync,"LibGCP",form, ##args); }
#define GCPDPRINT_DRAW(form,args...)   if (_gcpDebugState & GCPDEBUG_DRAW) { ggDPrintf(_gcpDebugSync,"LibGCP",form, ##args); }
#define GCPDPRINT_MISC(form,args...)   if (_gcpDebugState & GCPDEBUG_MISC) { ggDPrintf(_gcpDebugSync,"LibGCP",form, ##args); }
#define GCPDPRINT_LIBS(form,args...)   if (_gcpDebugState & GCPDEBUG_LIBS) { ggDPrintf(_gcpDebugSync,"LibGCP",form, ##args); }
#define GCPDPRINT_EVENTS(form,args...) if (_gcpDebugState & GCPDEBUG_EVENTS) { ggDPrintf(_gcpDebugSync,"LibGCP",form, ##args); }
#else /* DEBUG */
#define GCPDPRINT(form,args...)		do{}while(0)
#define GCPDPRINT_CORE(form,args...)	do{}while(0)
#define GCPDPRINT_MODE(form,args...)	do{}while(0)
#define GCPDPRINT_COLOR(form,args...)	do{}while(0)
#define GCPDPRINT_DRAW(form,args...)	do{}while(0)
#define GCPDPRINT_MISC(form,args...)	do{}while(0)
#define GCPDPRINT_LIBS(form,args...)	do{}while(0)
#define GCPDPRINT_EVENTS(form,args...)	do{}while(0)
#endif /* DEBUG */

#else /* __GNUC__ */

__BEGIN_DECLS

static inline void GCPDPRINT(const char *form,...)
{
#ifdef DEBUG
	if (_gcpDebugState) {
		va_list args;

		fprintf(stderr, "GCP: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gcpDebugSync) fflush(stderr);
	}
#endif
}

static inline void GCPDPRINT_CORE(const char *form,...)
{
#ifdef DEBUG
	if (_gcpDebugState & GCPDEBUG_CORE) {
		va_list args;

		fprintf(stderr, "GCP: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gcpDebugSync) fflush(stderr);
	}
#endif
}

static inline void GCPDPRINT_MODE(const char *form,...)
{
#ifdef DEBUG
	if (_gcpDebugState & GCPDEBUG_MODE) {
		va_list args;

		fprintf(stderr, "GCP: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gcpDebugSync) fflush(stderr);
	}
#endif
}

static inline void GCPDPRINT_COLOR(const char *form,...)
{
#ifdef DEBUG
	if (_gcpDebugState & GCPDEBUG_COLOR) {
		va_list args;

		fprintf(stderr, "GCP: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gcpDebugSync) fflush(stderr);
	}
#endif
}

static inline void GCPDPRINT_DRAW(const char *form,...)
{
#ifdef DEBUG
	if (_gcpDebugState & GCPDEBUG_DRAW) {
		va_list args;

		fprintf(stderr, "GCP: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gcpDebugSync) fflush(stderr);
	}
#endif
}

static inline void GCPDPRINT_MISC(const char *form,...)
{
#ifdef DEBUG
	if (_gcpDebugState & GCPDEBUG_MISC) {
		va_list args;

		fprintf(stderr, "GCP: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gcpDebugSync) fflush(stderr);
	}
#endif
}

static inline void GCPDPRINT_LIBS(const char *form,...)
{
#ifdef DEBUG
	if (_gcpDebugState & GCPDEBUG_LIBS) {
		va_list args;

		fprintf(stderr, "GCP: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gcpDebugSync) fflush(stderr);
	}
#endif
}

static inline void GCPDPRINT_EVENTS(const char *form,...)
{
#ifdef DEBUG
	if (_gcpDebugState & GCPDEBUG_EVENTS) {
		va_list args;

		fprintf(stderr, "GCP: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_gcpDebugSync) fflush(stderr);
	}
#endif
}

__END_DECLS

#endif /* __GNUC__ */

#ifdef DEBUG
#define GCP_ASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"GCP:%s:%d: INTERNAL ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#define GCP_APPASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"GCP:%s:%d: APPLICATION ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#else /* DEBUG */
#define GCP_ASSERT(x,str)	do{}while(0)
#define GCP_APPASSERT(x,str)	do{}while(0)
#endif /* DEBUG */

#ifdef DEBUG
# define GCPD0(x)	x
#else
# define GCPD0(x)	/* empty */
#endif

#ifdef GCPDLEV
# if GCPDLEV == 1
#  define GCPD1(x)	x
#  define GCPD2(x)	/* empty */
#  define GCPD3(x)	/* empty */
# elif GCPDLEV == 2
#  define GCPD1(x)	x
#  define GCPD2(x)	x
#  define GCPD3(x)	/* empty */
# elif GCPDLEV > 2
#  define GCPD1(x)	x
#  define GCPD2(x)	x
#  define GCPD3(x)	x
# endif
#else
# define GCPD1(x)	/* empty */
# define GCPD2(x)	/* empty */
# define GCPD3(x)	/* empty */
#endif

#endif /* _GCP_INTERNAL_DEBUG_H */
