/* $Id: order.c,v 1.1.1.1 2001/04/22 19:00:37 cegger Exp $
******************************************************************************

   Graphics library for GGI. WMH stuff.

   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "xwmh.h"


int GGIwmh_x_zorder  (ggi_visual_t vis,enum ordercmd command)
{
	ggi_xwin_common *priv;                                                   
	priv=LIBGGI_PRIVATE(vis);

	switch(command)
	{
		case ZO_TOP:
			ggLock(priv->x.xliblock);
			XRaiseWindow(priv->x.display, priv->window);
		        XSync(priv->x.display,0);
			ggUnlock(priv->x.xliblock);
			return 0;
		case ZO_BOTTOM:
			ggLock(priv->x.xliblock);
			XLowerWindow(priv->x.display, priv->window);
		        XSync(priv->x.display,0);
			ggUnlock(priv->x.xliblock);
			return 0;
		default:
			return -1;
	}
	return -1;
}

