/* $Id: texts.c,v 1.1.1.1 2001/04/22 19:00:37 cegger Exp $
******************************************************************************

   Graphics library for GGI. WMH stuff. Texts, titles and stuff.

   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "xwmh.h"


int GGIwmh_x_settitle(ggi_visual *vis,const char *title)
{
	ggi_xwin_common *priv;                                                   
	priv=LIBGGI_PRIVATE(vis);

	ggLock(priv->x.xliblock);
	XStoreName(priv->x.display, priv->window, title);
        XSync(priv->x.display,0);
	ggUnlock(priv->x.xliblock);

	return 0;
}

int GGIwmh_x_seticontitle(ggi_visual *vis,const char *title)
{
	ggi_xwin_common *priv;                                                   
	priv=LIBGGI_PRIVATE(vis);

	ggLock(priv->x.xliblock);
	XSetIconName(priv->x.display, priv->window, title);
        XSync(priv->x.display,0);
	ggUnlock(priv->x.xliblock);

	return 0;
}

int GGIwmh_x_iconify(ggi_visual *vis,int onoff)
{
	ggi_xwin_common *priv;                                                   
	priv=LIBGGI_PRIVATE(vis);

	ggLock(priv->x.xliblock);
	if (onoff) {
		XIconifyWindow(priv->x.display, priv->window, priv->x.screen);
	} else {
		XMapWindow(priv->x.display, priv->window);
	}
        XSync(priv->x.display,0);
	ggUnlock(priv->x.xliblock);

	return 0;
}

