/*
******************************************************************************

   Demo of the Lib${Name} extension.

   ${CopyByWhoWhen}
  
   ${CopyNotice}

******************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#include <ggi/ggi.h>
#include <ggi/${name}.h>

int main(void)
{
	ggi_visual_t vis;

	/* Initialize LibGGI */
	if (ggiInit() != 0) {
		fprintf(stderr, "Unable to initialize LibGGI\n");
		exit(1);
	}
	
	/* Initialize Lib${Name} extension */
	if (${Name}Init() != 0) {
		ggiPanic("Unable to initialize Lib${Name} extension\n");
	}

	/* Open the default visual */
	if ((vis = ggiOpen(NULL)) == NULL) {
		ggiPanic("Unable to open default visual\n");
	}
	
	/* Turn on asynchronous mode (which should always be used) */
	ggiSetFlags(vis, GGIFLAG_ASYNC);
	
	/* Set the default mode */
	if (ggiSetSimpleMode(vis, GGI_AUTO, GGI_AUTO, GGI_AUTO, GT_AUTO) < 0) {
		ggiPanic("Unable to set default mode\n");
	}
	
	/* Attach the Lib${Name} extension to the visual */
	if (${Name}Attach(vis) < 0) {
		ggiPanic("Unable to attach Lib${Name} extension to visual\n");
	}

	/* Try the API functions */

	/*-* Edit and uncomment the calls to test */

	/* Detach the Lib${Name} extension from visual */
	${Name}Detach(vis);

	/* Close visual */
	ggiClose(vis);

	/* Deinitialize Lib${Name} extension */
	${Name}Exit();

	/* Deinitialize LibGGI */
	ggiExit();

	return 0;
}
