/*
******************************************************************************

   Lib${Name} extension API header file.

   ${CopyByWhoWhen}
  
   ${CopyNotice}

******************************************************************************
*/

#include <stdio.h>
#include <string.h>

#include "config.h"
#include <ggi/internal/${name}.h>

#include <ggi/gg.h> /* We use LibGG to manage config files */


/* Static variables 
 */
static int 	 _${origName}LibIsUp       = 0;
static void	*_${origName}ConfigHandle  = NULL;
static char      _${origName}confstub[512] = ${NAME}CONFFILE;
static char     *_${origName}conffile      = _${origName}confstub+${NAME}TAGLEN;

/* Extension ID. Defaulting to -1 should make segfault on abuse more likely...
   This is exported so that sublibs can use it.
 */
EXPORTVAR ggi_extid _${origName}ID = -1;


/* Dummy function which returns -1
   We use this to reset the function pointers */
static int dummyfunc(void)
{
	printf("Lib${Name}: dummyfunc() of Lib${Name} called\n");

	return -1;
}

/*-* Reset all function pointers to dummyfunc */
static void clearfuncs(${origName}priv *priv)
{
}


/* This function is called by LibGGI when the API-list changes */
static int changed(ggi_visual_t vis, int whatchanged)
{
	printf("Lib${Name}: changed(%p, 0x%x) of Lib${Name} called\n",
	       vis, whatchanged);

	switch (whatchanged) {
	case GGI_CHG_APILIST: {
		int i;
		const char *fname;
		ggi_dlhandle *lib;
		char api[GGI_MAX_APILEN], args[GGI_MAX_APILEN];

		clearfuncs(LIBGGI_${NAME}EXT(vis));

		for(i=0; ggiGetAPI(vis, i, api, args) == 0; i++) {
			strcat(api,"-${name}");
			fname = ggMatchConfig(_${origName}ConfigHandle, api, NULL);
			if (fname == NULL) {
				/* No special implementation for this sublib */
				continue;
			}
			lib = ggiExtensionLoadDL(vis, fname, args, NULL, 
						 "${NAME}dl_");
		}
	}
	break;
	}
                                
	return 0;
}


/* Initialize the extension
 */
int ${Name}Init(void)
{
	int err;

	_${origName}LibIsUp++;
	if (_${origName}LibIsUp > 1) return 0; /* Initialize only at first call. */

	err = ggLoadConfig(_${origName}conffile, &_${origName}ConfigHandle);
	if (err != GGI_OK) {
		fprintf(stderr,"Lib${Name}: couldn't open %s\n",
			_${origName}conffile);
		_${origName}LibIsUp--;
		return err;
	}

	_${origName}ID = ggiExtensionRegister("${NAME}", sizeof(${origName}priv), changed);

	if (_${origName}ID < 0) {
		fprintf(stderr,
			"Lib${Name}: failed to register as extension.\n");
		_${origName}LibIsUp--;
		ggFreeConfig(_${origName}ConfigHandle);
		return _${origName}ID;
	}

	return 0;
}


/* Deinitialize the extension
 */
int ${Name}Exit(void)
{
	int rc;
    
	if (!_${origName}LibIsUp) return -1;

	if (_${origName}LibIsUp > 1) {
		/* Exit only at last call */
		_${origName}LibIsUp--;
		return 0;
	}
	
	rc = ggiExtensionUnregister(_${origName}ID);
	ggFreeConfig(_${origName}ConfigHandle);

	_${origName}LibIsUp = 0;

	return rc;
}


/* Attach the extension to a visual
 */
int ${Name}Attach(ggi_visual_t vis)
{
	int rc;

	printf("Lib${Name}: ${origName}Attach(%p) called\n", vis);

	rc = ggiExtensionAttach(vis, _${origName}ID);
	if (rc == 0) {
		/* We are actually creating the primary instance. */
		memset(LIBGGI_${NAME}EXT(vis), 0, sizeof(${origName}priv));

		/*-* Apply initial values */

		/* Now fake an "API change" so the right libs get loaded */
		changed(vis, GGI_CHG_APILIST);
	}

	return rc;
}


/* Detach the extension from a visual
 */
int ${Name}Detach(ggi_visual_t vis)
{
	printf("Lib${Name}: ${origName}Detach(%p) called\n", vis);

	return ggiExtensionDetach(vis, _${origName}ID);
}

/* This should be included by exactly _one_ file in each extension library. */
#include <ggi/internal/ggilibinit.h>

