/*
 ******************************************************************************

 LIBGPF: parse functions

 Copyright (C) 2001-2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include <ggi/internal/gpf.h>
#include <ggi/internal/gpf_internal.h>
#include <ggi/internal/gpf_debug.h>

#include <stdlib.h>
#include <string.h>
#include <stdarg.h>


int _gpfParseArgs(const char *args, va_list *argptr, ...)
{
	va_list ap;
	char *fmt;
	void **ptr, *argptr_ptr;
	char **str, *argptr_str;
	int **integer, *argptr_int;
	long **longint, *argptr_long;

	GPFDPRINT_CORE("_gpfParseArgs(%s) called\n", args);

	va_start(ap, argptr);

	for (fmt = (char *)args; *fmt; fmt++) {
		if (fmt[0] != '%') continue;
		if (!fmt[1]) continue;

		switch (fmt[1]) {
		case '%': continue;
		case 'p':	/* pointer */
			ptr = va_arg(ap, void *);
			argptr_ptr = va_arg(argptr[0], void *);

			memcpy(ptr, &argptr_ptr, sizeof(void *));

			GPFDPRINT_CORE("pointer: (%p)\n", ptr[0]);
			continue;

		case 's':	/* string */
			str = va_arg(ap, char **);
			argptr_str = va_arg(argptr[0], char *);

			strncpy(str[0], argptr_str, strlen(argptr_str)+1);

			GPFDPRINT_CORE("string: (%s)\n", str[0]);
			continue;

		case 'i':	/* integer */
		case 'x':	/* hex (lowcase) */
		case 'X':	/* hex (bigcase) */
			/* we handle a hex-value as an integer,
			 * because, we have to store it
			 * as a string otherwise...
			 */
			integer = va_arg(ap, int **);
			argptr_int = va_arg(argptr[0], int *);

			memcpy(integer, &argptr_int, sizeof(int *));

			GPFDPRINT_CORE("integer: (%i)\n", integer[0]);
			continue;

		case 'l':	/* long int */
			longint = va_arg(ap, long **);
			argptr_long = va_arg(argptr[0], long *);

			memcpy(longint, &argptr_long, sizeof(long *));

			GPFDPRINT_CORE("longint: (%i)\n", longint[0]);
			continue;

		}	/* switch */
	}	/* for */

	va_end(ap);

	GPFDPRINT_CORE("_gpfParseArgs: leave\n");

	return GGI_OK;
}	/* _gpfParseArgs */




int _gpfGetLastArg(const char *fmt, va_list *ap)
{
	void *arg = NULL;

	for (; *fmt; fmt++) {
		if (fmt[0] != '%') continue;
		if (!fmt[1]) continue;

		switch (fmt[1]) {
		case '%': continue;
		case 'p':	/* pointer */
			arg = va_arg(ap[0], void *);
			continue;

		case 's':	/* string */
			arg = va_arg(ap[0], char *);
			continue;

		}	/* switch */

	}	/* for */

	return GGI_OK;
}	/* _gpfGetLastArg */




int _gpfParseProtocol(const char *argf, va_list argptr,
		char *protocol, char *proto_argf, va_list *proto_argptr)
{
	char *str = NULL;

	LIB_ASSERT(protocol != NULL);
	LIB_ASSERT(proto_argf != NULL);
	LIB_ASSERT(proto_argptr != NULL);


	GPFDPRINT_CORE("_gpfParseProtocol(%s, %p, %s, %s) called\n",
			argf, argptr, protocol, proto_argf);

	do {
		if (argf != NULL) {
			str = strchr(argf, ':');
		}	/* if */

		if (argf == NULL || str == NULL) {
			/* default protocol */
			strcpy(protocol, "target");
			break;
		} 	/* if */

		if (str[0] == ':') {
			/* protocol identified */
			memcpy(protocol, argf, strlen(argf) - strlen(str));
			str++;		

			memcpy(proto_argf, str, strlen(str) + 1);

			GPFDPRINT_CORE("%s:%s:%i: Protocol (%s, %s)\n",
				DEBUG_INFO, protocol, proto_argf);
		}	/* if */

	} while (0);

	proto_argptr[0] = (argptr != NULL) ? argptr : NULL;

	return GGI_OK;
}	/* _gpfParseProtocol */
