/*
 ******************************************************************************

 LIBGPF: pipe functions

 Copyright (C) 2001-2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include <ggi/internal/gpf.h>
#include <ggi/internal/gpf_internal.h>
#include <ggi/internal/gpf_debug.h>

#include <stdlib.h>
#include <string.h>


/* Currently, the pipe sublib currently don't need any args passed by the
 * pipeline management. But I leave that code as a sort of dummy-code in
 * order to readd it quickly, if it turns out, that it is needed later again.
 */

va_list _gpfArgs2valist(void *dummy, ...)
{
	va_list ap;

	va_start(ap, dummy);

	return ap;
}	/* _gpfArgs2valist */


struct gpf_pipeline_item_t *_gpfOpenPipe(const char *pipe_string)
{
	struct gpf_pipeline_item_t *pipe = NULL;
	va_list ap;

	int rc;

	LIB_ASSERT(pipe_string != NULL);

	GPFDPRINT_CORE("%s:%s:%i: load pipe\n", DEBUG_INFO);

	pipe = _gpfPipelineItemCreate();
	if (!pipe) {
		rc = GGI_ENOMEM;
		goto err0;
	}	/* if */

	ap = _gpfArgs2valist(NULL);

	rc = _gpfOpenDL(NULL, pipe, pipe_string, "",
			ap, GPF_DLTYPE_LOCAL);
	va_end(ap);
	if (rc != GGI_OK) {
		goto err1;
	}	/* if */

	strncpy(pipe->pipe_string, pipe_string, GGI_MAX_APILEN);

	LIB_ASSERT(rc == GGI_OK);
	return pipe;

err1:
	_gpfPipelineItemDestroy(&pipe);
err0:
	return NULL;
}	/* _gpfOpenPipe */


int _gpfClosePipe(struct gpf_pipeline_item_t **pipe)
{
	int rc;

	LIB_ASSERT(pipe != NULL);
	LIB_ASSERT(pipe[0] != NULL);

	GPFDPRINT_CORE("%s:%s:%i: close pipe\n", DEBUG_INFO);

	do {
		rc = _gpfCloseDL(pipe[0]);
		if (rc != GGI_OK) {
			break;
		}	/* if */

		free(pipe[0]);
		pipe[0] = NULL;
	} while (0);

	return rc;
}	/* _gpfClosePipe */

