/*
 ******************************************************************************

 LIBGPF: stubs

 Copyright (C) 2001-2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include <ggi/internal/gpf.h>


/* for multiframe Formats (animated gif, interlaced jpeg, video, ...)
 */
int gpfSetCurrFrame(gpf_handle_t handle, int num_frame)
{
	return handle->opio_input->setcurrframe(handle->opio_input,
					num_frame);
}	/* gpfSetCurrFrame */


int gpfGetCurrFrame(gpf_handle_t handle, int *num_frame)
{
	return handle->opio_input->getcurrframe(handle->opio_input,
					num_frame);
}	/* gpfGetCurrFrame */


int gpfGetNumFrames(gpf_handle_t handle, int *num_frames)
{
	return handle->opio_input->getnumframes(handle->opio_input,
					num_frames);
}	/* gpfGetNumFrames */


int gpfSetTransferRate(struct gpf_properties_t *props, int rate)
{
	props->transfer_rate = rate;

	return 0;
}	/* gpfSetTransferRate */


int gpfGetTransferRate(gpf_handle_t handle)
{
#if 0
	return handle->pipeline->gettransferrate(handle);
#else
#warning Implement
	return -1;
#endif
}	/* gpfGetTransferRate */

