/*
 ******************************************************************************

 LIBGPF: library helpers

 Copyright (C) 2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#ifndef _GPF_INTERNAL_HELPERS_H
#define _GPF_INTERNAL_HELPERS_H


#include <ggi/internal/gpf.h>


void _gpf_mem_error(void);
void *_gpf_malloc(size_t siz);
void *_gpf_calloc(size_t siz);
void *_gpf_realloc(void *ptr, size_t siz);


int _gpf_alloc_readbuf(struct gpf_pipeline_item_t *pipe, size_t siz);
int _gpf_realloc_readbuf(struct gpf_pipeline_item_t *pipe, size_t siz);
int _gpf_free_readbuf(struct gpf_pipeline_item_t *pipe);

int _gpf_alloc_writebuf(struct gpf_pipeline_item_t *pipe, size_t siz);
int _gpf_realloc_writebuf(struct gpf_pipeline_item_t *pipe, size_t siz);
int _gpf_free_writebuf(struct gpf_pipeline_item_t *pipe);


#endif	/* _GPF_INTERNAL_HELPERS_H */
