/*
 ******************************************************************************

 LIBGPF: rgba io pipe header

 Copyright (C) 2001-2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include <ggi/internal/gpf.h>
#include <ggi/internal/gpf_debug.h>
#include <ggi/internal/gpf_helpers.h>

#include <string.h>


/*
 *      "exported" Function prototypes
 */

GPFpipe_setup			GPF_RGBA_setup;
GPFpipe_getformat		GPF_RGBA_getformat;
GPFpipe_getinfolist		GPF_RGBA_getinfolist;
GPFpipe_TransferNextStreamBlock	GPF_RGBA_transfernextstreamblock;


/*
 *	internal function prototypes
 */


struct rgbagpf_priv;

typedef ssize_t (DoConversion)(struct gpf_pipeline_t *pipeline,
				struct gpf_pipeline_item_t *pipe,
				size_t buf_size);

typedef int (GPF_map)(struct rgbagpf_priv *rgba, char *buf_map,
			size_t input_size, size_t output_size);			
typedef int (GPF_unmappixel)(struct rgbagpf_priv *rgba, char *buf_unmap,
			size_t input_size, size_t output_size);



/* Structures needed by private structure
 */

typedef struct {
	/* total = length(mask) + shift(mask)
	 */
	int red_map_output;
	int red_unmap_input;
	int red_mask_input, red_mask_output;
	int red_nbits_input, red_nbits_output;
	int green_map_output;
	int green_unmap_input;
	int green_mask_input, green_mask_output;
	int green_nbits_input, green_nbits_output;
	int blue_map_output;
	int blue_unmap_input;
	int blue_mask_input, blue_mask_output;
	int blue_nbits_input, blue_nbits_output;
} color_truepriv;

typedef struct {
	int shift_input;
	int shift_output;
} color_greypriv;



/* Structure holding private data.
 */
struct rgbagpf_priv {
	size_t input_data_size;
	size_t output_data_size;

	struct gpf_pixelformat_t pf_input;
	struct gpf_pixelformat_t pf_output;

	GPF_map		*domap;
	GPF_unmappixel	*dounmap;
	DoConversion	*doconversion;

	union {
		color_truepriv truecol;
		color_greypriv grey;
	} colorpriv;
};


#define RGBA_PRIV(pipe)		\
		((struct rgbagpf_priv *)(LIBGPF_PIPE_PRIVATE(pipe)))

#define COLOR_TRUEPRIV(rgba_priv)	((color_truepriv*)(&(rgba_priv)->colorpriv.truecol))
#define COLOR_GREYPRIV(rgba_priv)	((color_greypriv*)(&(rgba_priv)->colorpriv.grey))
