/*
 ******************************************************************************

 LIBGPF: pipe functions

 Copyright (C) 2002 <Author>	[<you@there.de>]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include "<sample>_gpf.h"

static int _<sample>_getinfonr(int chain)
{
	switch (chain) {
	case INFOLIST_INPUT:

#warning Return the total number of supported (pixel-)formats here
		return 1;

	case INFOLIST_OUTPUT:

#warning Return the total number of supported (pixel-)formats here
		return 1;

	}	/* switch */

	return 0;
}	/* _<sample>_getinfonr */


/* fills in the information of pixelformats it can handle
 * from the input
 */
static void _<sample>_fillinfo_input(struct gpf_pipeline_item_t *pipe,
			struct gpf_infolist_t *item,
			int nr)
{
	LIB_ASSERT(pipe != NULL);
	LIB_ASSERT(item != NULL);

	/* Initizalize everything with zero */
	memset(&item->pf, 0, sizeof(struct gpf_pixelformat_t));

	/* You may set up common values for all formats here
	 */

	switch (nr) {
	case 0:
		/* Format 1
		 */

		item->pf.cf = GPF_CF_<cf_flag>;
		item->pf.flags = GPF_PIPE_<df_flags>;


		item->pf.depth = ?;	/* significant bits per pixel */
		item->pf.size = ?;	/* total used bits per pixel */


#warning Set the right mask values

		/* ... except you use the GPF_PIPE_DF_ALLVARIANTS
		 * flag here. In that case, you don't need to do
		 * anything here, but removing the #warning and the
		 * two above item->pf.* lines
		 */


		LIB_ASSERT(<sample>_PRIV(pipe)->input_data_size > 0);
		item->memory_usage = <sample>_PRIV(pipe)->input_data_size;
		item->runtime = item->memory_usage * 1.0;
		break;

	default:
		fprintf(stderr, "Unknown nr: %i\n", nr);
		break;
	}	/* switch */

	return;
}	/* _<sample>_fillinfo_input */


/* fills in the information of pixelformats it can convert to
 */
static void _<sample>_fillinfo_output(struct gpf_pipeline_item_t *pipe,
			struct gpf_infolist_t *item,
			int nr)
{
	LIB_ASSERT(pipe != NULL);
	LIB_ASSERT(item != NULL);

	/* Initizalize everything with zero */
	memset(&item->pf, 0, sizeof(struct gpf_pixelformat_t));

	/* You may set up common values for all formats here
	 */

	switch (nr) {
	case 0:
		item->pf.cf = GPF_CF_<cf_flag>;
		item->pf.flags = GPF_PIPE_<df_flags>;

		item->pf.depth = ?;	/* significant bits per pixel */
		item->pf.size = ?;	/* total used bits per pixel */


#warning Set the right mask values

		/* ... except you use the GPF_PIPE_DF_ALLVARIANTS
		 * flag here. In that case, you don't need to do
		 * anything here, but removing the #warning and the
		 * two above item->pf.* lines
		 */

		LIB_ASSERT(<sample>_PRIV(pipe)->output_data_size > 0);
		item->memory_usage = <sample>_PRIV(pipe)->output_data_size;
		item->runtime = item->memory_usage * 2.0;
		break;

	default:
		fprintf(stderr, "Unknown nr: %i\n", nr);
		break;
	}	/* switch */

	return;
}	/* _<sample>_fillinfo_output */




static void _<sample>_fillinfo(struct gpf_pipeline_item_t *pipe,
			struct gpf_infolist_t *item,
			int nr, int chain)
{
	LIB_ASSERT(pipe != NULL);
	LIB_ASSERT(item != NULL);

	switch (chain) {
	case INFOLIST_INPUT:
		_<sample>_fillinfo_input(pipe, item, nr);
		break;

	case INFOLIST_OUTPUT:
		_<sample>_fillinfo_output(pipe, item, nr);
		break;

	}	/* switch */

	return;
}	/* _<sample>_fillinfo */



static struct gpf_infolist_t *_<sample>_getInfolist(
					struct gpf_pipeline_item_t *pipe,
					int chain)
{
	int nr, i;
	struct gpf_infolist_t *head = NULL;
	struct gpf_infolist_t *item = NULL;

	LIB_ASSERT(pipe != NULL);

	nr = _<sample>_getinfonr(chain);
	item = _gpfInfoListCreate();
	if (!item) {
		goto err0;
	}	/* if */
	_<sample>_fillinfo(pipe, item, 0, chain);
	head = item;

	for (i = 1; i < nr; i++) {
		item = _gpfInfoListCreate();
		if (!item) {
			goto err1;
		}	/* if */

		_<sample>_fillinfo(pipe, item, i, chain);

		_gpfInfoListAppend(head, item);
	}	/* for */


	return head;


err1:
	_gpfInfoListDestroy(&item);
	_gpfInfoListDestroy(&head);
err0:
	return NULL;
}	/* _<sample>_getInfolist */



/* connect the items from the input and output information list
 * together, that can be converted from/to.
 */
static int _<sample>_connectinfolist(struct gpf_infolist_t *input_head,
				struct gpf_infolist_t *output_head)
{
	struct gpf_infolist_t *input_idx = NULL;
	struct gpf_infolist_t *output_idx = NULL;


	/* This connects all supported formats from the input
	 * with all supported formats going to the output.
	 * That means, that each input-format can be converted
	 * into each output format.
	 * If this is not true to your pipe, change this.
	 */


	for_each_infolist(input_head, input_idx) {
		for_each_infolist(output_head, output_idx) {

			/* Connect all items together */
			_gpfInfoListConnect(input_idx, output_idx);

		}	/* for */
	}	/* for */

	return GGI_OK;
}	/* _<sample>_connectinfolist */



int GPF_<sample>_getinfolist(struct gpf_pipeline_item_t *pipe)
{
	int rc = GGI_OK;

	LIB_ASSERT(pipe != NULL);

	LIB_ASSERT(pipe->input_head == NULL);
	LIB_ASSERT(pipe->output_head == NULL);


	pipe->input_head = _<sample>_getInfolist(pipe, INFOLIST_INPUT);
	if (!pipe->input_head) {
		goto err0;
	}	/* if */

	pipe->output_head = _<sample>_getInfolist(pipe, INFOLIST_OUTPUT);
	if (!pipe->output_head) {
		goto err1;
	}	/* if */

	rc = _<sample>_connectinfolist(pipe->input_head, pipe->output_head);
	LIB_ASSERT(rc == GGI_OK);

	return rc;

err1:
	_gpfInfoListDestroy(&pipe->input_head);
err0:
	return rc;
}	/* GPF_<sample>_getinfolist */

