/*
 ******************************************************************************

 LIBGPF: file protocol header

 Copyright (C) 2001-2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include <ggi/internal/gpf.h>
#include <ggi/internal/gpf_debug.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>


/*
 *      "exported" Function prototypes
 */

GPFproto_open		GPF_FILE_open;
GPFproto_close		GPF_FILE_close;

GPFproto_read		GPF_FILE_read;
GPFproto_write		GPF_FILE_write;

GPFproto_lseek		GPF_FILE_lseek;
GPFproto_flush		GPF_FILE_flush;
GPFproto_eos		GPF_FILE_eos;


#define FILE_BUFFER_SIZE	1024

/* Structure holding private data.
 */
struct filegpf_priv {
	int fd;
	char location[GPF_MAXPARAM_LEN];

	/* input buffering */
	int read_buf_idx;
	int read_buf_len;
	uint8 read_buffer[FILE_BUFFER_SIZE];

	/* output buffering */
	int write_buf_len;
	uint8 write_buffer[FILE_BUFFER_SIZE];
};

#define FILE_PRIV(io)		\
		((struct filegpf_priv *)(LIBGPF_PROTO_PRIVATE(io)))
