/*
 ******************************************************************************

 LIBGPF: file protocol initialisation

 Copyright (C) 2001-2002 Christoph Egger	[Christoph_Egger@t-online.de]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include "file_gpf.h"
#include <ggi/internal/gpf_internal.h>

#include <string.h>

static int GPFinit(struct gpf_handle_opio_t *opio,
		const char *args, va_list ap)
{
	char *location;


	GPFDPRINT_PROTO("%s:%s:%i: args (%s)\n", DEBUG_INFO, args);

	if (!args || !args[0]) {
		fprintf(stderr, "display-file: Missing filename.\n");
		return GGI_EARGREQ;
	}	/* if */

	location = FILE_PRIV(opio)->location;
	memcpy(location, args, strlen(args)+1);

	GPFDPRINT_PROTO("%s:%s:%i: location (%s)\n",
		DEBUG_INFO, FILE_PRIV(opio)->location);

	return GGI_OK;
}	/* GPFinit */



static int GPFopen(struct gpf_handle_opio_t *opio,
		   struct gpf_pipeline_item_t *pipe,
		   struct gpf_dlhandle *dlh, const char *args,
		   va_list ap, uint32 *dlret)
{
	int rc;
	struct filegpf_priv *priv;


	GPFDPRINT_LIBS("GPFopen(%p, %p, %p, %s, %p, %p) called for file sublib\n",
		opio, pipe, dlh, args ? args : "(NULL)", ap, dlret);

	LIBGPF_PROTO_PRIVATE(opio) = malloc(sizeof(struct filegpf_priv));
	if (LIBGPF_PROTO_PRIVATE(opio) == NULL) return GGI_ENOMEM;

	priv = FILE_PRIV(opio);

	memset(priv, 0, sizeof(struct filegpf_priv));

	rc = GPFinit(opio, args, ap);

	if (rc == GGI_OK) {
		opio->opproto->open = GPF_FILE_open;
		opio->opproto->close = GPF_FILE_close;

		opio->opproto->read = GPF_FILE_read;
		opio->opproto->write = GPF_FILE_write;

		opio->opproto->lseek = GPF_FILE_lseek;
		opio->opproto->flush = GPF_FILE_flush;
		opio->opproto->eos = GPF_FILE_eos;
	}	/* if */

	*dlret = (GPF_DL_OPPROTO);
	return rc;
}	/* GPFopen */


static int GPFclose(struct gpf_pipeline_item_t *pipe,
		    struct gpf_dlhandle *dlh)
{
	GPFDPRINT_LIBS("GPFclose(%p, %p) called for file sublib\n",
			pipe, dlh);

	free(LIBGPF_PIPE_PRIVATE(pipe));
	LIBGPF_PIPE_PRIVATE(pipe) = NULL;

	return 0;
}	/* GPFclose */


int GPFdl_file(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GPFopen;
		return 0;
	case GGIFUNC_exit:
		*funcptr = NULL;
		return 0;
	case GGIFUNC_close:
		*funcptr = GPFclose;
		return 0;
	default:
		*funcptr = NULL;
	}	/* switch */

	return GGI_ENOTFOUND;
}	/* GPFdl_file */


/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
