/*
 ******************************************************************************

 LIBGPF: <sample> protocol functions

 Copyright (C) 2002 <Author>	[<you@there.com>]

 Permission is hereby granted, free of charge, to any person obtaining a
 copy of this software and associated documentation files (the "Software"),
 to deal in the Software without restriction, including without limitation
 the rights to use, copy, modify, merge, publish, distribute, sublicense,
 and/or sell copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 ******************************************************************************
 */

#include "<sample>_gpf.h"
#include <string.h>


int GPF_<sample>_open(struct gpf_handle_opio_t *opio, int flags)
{
	int rc = GGI_OK;
	struct <sample>gpf_priv *priv;

	priv = <sample>_PRIV(opio);

#warning open the physical device (i.e. network connection) here

	return rc;
}	/* GPF_FILE_open */


int GPF_<sample>_close(struct gpf_handle_opio_t *opio)
{
	int rc;
	struct <sample>gpf_priv *priv;

	priv = <sample>_PRIV(opio);

	rc = opio->opproto->flush(opio);
	LIB_ASSERT(rc == GGI_OK);
#warning Handle rc < 0 appropriately

#warning Close the physical device here (i.e. network connection)

	return rc;
}	/* GPF_<sample>_close */


off_t GPF_<sample>_lseek(struct gpf_handle_opio_t *opio,
			off_t offset, int whence)
{
	off_t rc;
	struct <sample>gpf_priv *priv;

	priv = <sample>_PRIV(opio);

#warning This function has to behave like the lseek libc function

	/* You may use that libc function directly here */

	return rc;
}	/* GPF_<sample>_lseek */


int GPF_<sample>_flush(struct gpf_handle_opio_t *opio)
{
	int rc;
	struct <sample>gpf_priv *priv;

	priv = <sample>_PRIV(opio);

#warning Flush the cached data here

	return rc;
}	/* GPF_FILE_flush */



static int read_byte(struct <sample>gpf_priv *priv, uint8 *val)
{
	int rc = 1;

	GPFDPRINT_PROTO("%s:%s:%i: called (fd: %i, val: %p)\n",
			DEBUG_INFO, priv->fd, val);

#warning Read and return _exactly_ only one byte here

	/* Hint: You may actually read more than one byte here,
	 * but then you have to cache them
	 */

	return (rc > 0) ? 1 : rc;
}	/* read_byte */



ssize_t GPF_<sample>_read(struct gpf_handle_opio_t *opio,
		void *buf, size_t size)
{
	ssize_t rc = 0;
	size_t maxsize;
	struct <sample>gpf_priv *priv;

	priv = <sample>_PRIV(opio);

	GPFDPRINT_PROTO("%s:%s:%i: called (buf: %p, size: %i)\n",
			DEBUG_INFO, buf, size);

	maxsize = size;
	while (size--) {
		rc = read_byte(priv, (uint8 *)buf++);
		if (rc == 0) {
			opio->opproto->is_eos = 1;
			break;
		}	/* if */

		if (rc < 0) {
			/* error occured */
			break;
		}	/* if */
	}	/* while */

	GPFDPRINT_PROTO("%s:%s:%i: read data (%p, %i) - rc (%i)\n",
			DEBUG_INFO, buf, size, rc);

	return (rc < 0) ? rc : (maxsize - size);
}	/* GPF_<sample>_read */



static int write_byte(struct gpf_handle_opio_t *opio,
			uint8 val)
{
	int rc = 1;
	struct <sample>gpf_priv *priv;

	priv = <sample>_PRIV(opio);

#warning Write _exactly_ only one byte here

	/* You may cache the data here,
	 * but don't forget to flush the cache-buffer,
	 * when it is full
	 * Hint: use rc = opio->opproto->flush(opio);
	 */

	return (rc > 0) ? 1 : rc;
}	/* write_byte */



ssize_t GPF_<sample>_write(struct gpf_handle_opio_t *opio,
		void *buf, size_t size)
{
	ssize_t rc = 0;
	size_t maxsize;
	struct <sample>gpf_priv *priv;

	priv = <sample>_PRIV(opio);

	GPFDPRINT_PROTO("%s:%s:%i: called (buf: %p, size: %i)\n",
			DEBUG_INFO, buf, size);

	maxsize = size;
	while (size--) {
		rc = write_byte(opio, ((uint8 *)buf)[0]++);
		if (rc < 0) {
			/* error occured */
			break;
		}	/* if */
	}	/* while */

	GPFDPRINT_PROTO("%s:%s:%i: wrote data (%i, %p, %i) - rc (%i)\n",
			DEBUG_INFO, priv->fd, buf, size, rc);

	return (rc < 0) ? rc : (maxsize - size);
}	/* GPF_<sample>_write */


int GPF_<sample>_eos(struct gpf_handle_opio_t *opio)
{
	return opio->opproto->is_eos;
}	/* GPF_<sample>_eos */
