/*
 * Decompiled with CFR 0.152.
 */
package net.eggdrop.jet;

import com.sun.java.swing.JFrame;
import com.sun.java.swing.JTabbedPane;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.eggdrop.jet.adaptor.Module2MessageManagerAdaptor;
import net.eggdrop.jet.adaptor.Module2TalkPanelAdaptor;
import net.eggdrop.jet.adaptor.Module2TextOutPanelAdaptor;
import net.eggdrop.jet.adaptor.SocketManager2ModuleManagerAdaptor;
import net.eggdrop.jet.adaptor.TalkPanel2ModuleAdaptor;
import net.eggdrop.jet.gui.JTalkPanel;
import net.eggdrop.jet.gui.JTextOutPanel;
import net.eggdrop.jet.manager.InterfaceManager;
import net.eggdrop.jet.manager.MessageManager;
import net.eggdrop.jet.manager.ModuleManager;
import net.eggdrop.jet.manager.SocketManager;
import net.eggdrop.jet.module.ModuleBase;
import net.eggdrop.jet.module.ModuleCommands;
import net.eggdrop.jet.module.ModuleConsole;
import net.eggdrop.jet.module.ModuleMasterLine;
import net.eggdrop.jet.module.ModulePartyLine;
import net.eggdrop.jet.module.ModuleRaw;
import net.eggdrop.jet.module.ModuleWireLine;

public class Client {
    public static final String NAME = "JET - Java Eggdrop Telnet client";
    public static final String VERSION = "alpha0.4.0";
    public static final String COPYRIGHT = "Copyright (c) 1998";
    public static final String AUTHOR = "MHT - ManHatTan <mht@mygale.org>";
    public static boolean ECHO = true;
    public static boolean TIME_STAMP = false;

    public Client(String string, int n) {
        SocketManager socketManager = new SocketManager();
        if (socketManager.connect(string, n)) {
            InterfaceManager interfaceManager = new InterfaceManager();
            MessageManager messageManager = new MessageManager(socketManager, 250);
            ModuleManager moduleManager = new ModuleManager();
            new SocketManager2ModuleManagerAdaptor(socketManager, moduleManager);
            this.addModule(moduleManager, messageManager, interfaceManager.tabUp(), "Raw", "All Eggdrop messages", new ModuleRaw(), new JTalkPanel());
            this.addTextModule(moduleManager, messageManager, interfaceManager.textPane(), "   Console   ", "Events & Commands logs", new ModuleConsole(), new JTextOutPanel());
            this.addModuleAt(0, moduleManager, messageManager, interfaceManager.tabDown(), "MasterLine", "Master Line", new ModuleMasterLine(), new JTalkPanel(","));
            this.addModuleAt(1, moduleManager, messageManager, interfaceManager.tabDown(), "WireLine", "Wire Line", new ModuleWireLine(), new JTalkPanel(";"));
            this.addModuleAt(0, moduleManager, messageManager, interfaceManager.tabDown(), "PartyLine", "Chat & Party Line", new ModulePartyLine(), new JTalkPanel());
            this.addModuleAt(0, moduleManager, messageManager, interfaceManager.tabUp(), "Commands", "Eggdrop Commands", new ModuleCommands(), new JTalkPanel());
            JFrame jFrame = new JFrame("JET - Java Eggdrop Telnet client alpha0.4.0");
            jFrame.addWindowListener(new 1());
            jFrame.getContentPane().add((Component)((Object)interfaceManager));
            jFrame.setSize(640, 512);
            jFrame.setVisible(true);
            socketManager.start();
            System.out.println("Jet Client running...");
        }
    }

    protected void addTextModule(ModuleManager moduleManager, MessageManager messageManager, JTabbedPane jTabbedPane, String string, String string2, ModuleBase moduleBase, JTextOutPanel jTextOutPanel) {
        jTabbedPane.addTab(string, null, (Component)((Object)jTextOutPanel), string2);
        moduleBase.initModule();
        moduleManager.addModule(moduleBase);
        new Module2TextOutPanelAdaptor(moduleBase, jTextOutPanel);
    }

    protected void addModule(ModuleManager moduleManager, MessageManager messageManager, JTabbedPane jTabbedPane, String string, String string2, ModuleBase moduleBase, JTalkPanel jTalkPanel) {
        jTabbedPane.addTab(string, null, (Component)((Object)jTalkPanel), string2);
        moduleBase.initModule();
        moduleManager.addModule(moduleBase);
        new Module2TalkPanelAdaptor(moduleBase, jTalkPanel);
        new TalkPanel2ModuleAdaptor(jTalkPanel, moduleBase);
        new Module2MessageManagerAdaptor(moduleBase, messageManager);
    }

    protected void addModuleAt(int n, ModuleManager moduleManager, MessageManager messageManager, JTabbedPane jTabbedPane, String string, String string2, ModuleBase moduleBase, JTalkPanel jTalkPanel) {
        jTabbedPane.insertTab(string, null, (Component)((Object)jTalkPanel), string2, n);
        moduleBase.initModule();
        moduleManager.addModule(moduleBase);
        new Module2TalkPanelAdaptor(moduleBase, jTalkPanel);
        new TalkPanel2ModuleAdaptor(jTalkPanel, moduleBase);
        new Module2MessageManagerAdaptor(moduleBase, messageManager);
    }

    public static void main(String[] stringArray) {
        System.out.println("JET alpha0.4.0 - Copyright (c) 1998, by MHT - ManHatTan <mht@mygale.org>.");
        if (stringArray.length != 2) {
            System.out.println("Usage: net.eggdrop.jet.Client <eggieHost> <eggiePort>");
        } else {
            String string = stringArray[0];
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error: invalid port...");
                System.exit(-1);
            }
            Client client = new Client(string, n);
        }
    }

    class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }

        1() {
        }
    }
}

