/*
 * Decompiled with CFR 0.152.
 */
package net.eggdrop.jet.gui;

import com.sun.java.swing.Box;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.event.EventListenerList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import net.eggdrop.jet.event.MessageEvent;
import net.eggdrop.jet.event.MessageListener;
import net.eggdrop.jet.gui.JRecallTextField;
import net.eggdrop.jet.gui.JTextOutPanel;

public class JTalkPanel
extends JPanel {
    protected JPanel outPanel;
    protected JTextOutPanel outText;
    protected JPanel inPanel;
    protected JLabel inLabel;
    protected JRecallTextField inTextField;
    protected JButton clearButton;
    protected String inPrefix;
    private EventListenerList listenerList;
    private ClearButtonAction clearButtonAction;
    private InTextFieldAction inTextFieldAction;

    public JTalkPanel() {
        this("");
    }

    public JTalkPanel(String string) {
        this.design();
        this.listenerList = new EventListenerList();
        this.inPrefix = string;
        this.inTextField.requestFocus();
        this.prefixText("");
        this.inTextFieldAction = new InTextFieldAction(this, this.inTextField);
        this.clearButtonAction = new ClearButtonAction(this, this.clearButton);
    }

    protected void design() {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.inPanel = new JPanel();
        ((Container)((Object)this)).add("South", (Component)this.inPanel);
        this.outPanel = new JPanel();
        ((Container)((Object)this)).add("Center", (Component)this.outPanel);
        this.inPanel.setLayout(new BorderLayout());
        this.inPanel.add("North", Box.createVerticalStrut((int)4));
        this.inTextField = new JRecallTextField();
        this.inPanel.add("Center", (Component)((Object)this.inTextField));
        this.clearButton = new JButton("Clear");
        this.inPanel.add("East", (Component)this.clearButton);
        this.outPanel.setLayout(new BorderLayout());
        this.outText = new JTextOutPanel();
        this.outPanel.add("Center", (Component)((Object)this.outText));
    }

    public String getText() {
        return this.inTextField.getText();
    }

    public void setText(String string) {
        this.inTextField.setText(string);
    }

    public void prefixText(String string) {
        this.inTextField.setText(String.valueOf(this.inPrefix).concat(String.valueOf(string)));
    }

    public void setEditable(boolean bl) {
        this.inTextField.setEditable(bl);
    }

    public void message(MessageEvent messageEvent) {
        this.outText.message(messageEvent);
    }

    public void addMessageListener(MessageListener messageListener) {
        this.listenerList.add(Class.forName("net.eggdrop.jet.event.MessageListener"), (EventListener)messageListener);
    }

    public void removeMessageListener(MessageListener messageListener) {
        this.listenerList.remove(Class.forName("net.eggdrop.jet.event.MessageListener"), (EventListener)messageListener);
    }

    public void fireMessage(MessageEvent messageEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != Class.forName("net.eggdrop.jet.event.MessageListener")) continue;
            ((MessageListener)objectArray[i + 1]).message(messageEvent);
        }
    }

    private class ClearButtonAction
    implements ActionListener {
        private JTalkPanel talkPanel;
        private JButton clearButton;

        public ClearButtonAction(JTalkPanel jTalkPanel2, JButton jButton) {
            this.talkPanel = jTalkPanel2;
            this.clearButton = jButton;
            jButton.addActionListener((ActionListener)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.talkPanel.outText.clear();
            this.talkPanel.inTextField.resetRecalls();
            this.talkPanel.prefixText("");
        }
    }

    private class InTextFieldAction
    implements ActionListener {
        private JTalkPanel talkPanel;
        private JTextField inTextField;

        public InTextFieldAction(JTalkPanel jTalkPanel2, JTextField jTextField) {
            this.talkPanel = jTalkPanel2;
            this.inTextField = jTextField;
            jTextField.addActionListener((ActionListener)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.talkPanel.getText().equals(JTalkPanel.this.inPrefix)) {
                this.talkPanel.fireMessage(new MessageEvent(this, this.talkPanel.getText()));
                this.talkPanel.prefixText("");
            }
        }
    }
}

