/*
 * Decompiled with CFR 0.152.
 */
package net.eggdrop.jet.manager;

import com.sun.java.swing.event.EventListenerList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.EventListener;
import net.eggdrop.jet.event.SocketEvent;
import net.eggdrop.jet.event.SocketListener;

public class SocketManager
extends Thread {
    protected EventListenerList listenerList;
    protected Socket socket;
    protected BufferedReader is;
    protected PrintWriter os;
    protected boolean connected;

    public SocketManager() {
        System.out.println("SocketManager loaded.");
        this.listenerList = new EventListenerList();
        this.connected = false;
    }

    public SocketManager(String string, int n) {
        this.listenerList = new EventListenerList();
        this.connect(string, n);
    }

    public boolean connect(String string, int n) {
        try {
            System.out.print(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Connecting to ").concat(String.valueOf(string))).concat(String.valueOf(":"))).concat(String.valueOf(n))).concat(String.valueOf("... ")));
            this.socket = new Socket(string, n);
            this.is = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.os = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.connected = true;
            System.out.println("Connected!");
            this.fireSocket(1, String.valueOf(String.valueOf(string).concat(String.valueOf(":"))).concat(String.valueOf(n)));
        }
        catch (ConnectException connectException) {
            this.connected = false;
            System.out.println("Connection refused!");
        }
        catch (UnknownHostException unknownHostException) {
            this.connected = false;
            System.out.println("Unknown host!");
        }
        catch (NoRouteToHostException noRouteToHostException) {
            this.connected = false;
            System.out.println("No route to host!");
        }
        catch (IOException iOException) {
            this.connected = false;
            System.out.println(iOException.getMessage());
        }
        return this.connected;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public synchronized boolean sendMessage(String string) {
        if (!this.connected) {
            return false;
        }
        this.os.println(string);
        if (this.os.checkError()) {
            this.connected = false;
            this.fireSocket(0, null);
            return true;
        }
        return false;
    }

    public void addSocketListener(SocketListener socketListener) {
        this.listenerList.add(Class.forName("net.eggdrop.jet.event.SocketListener"), (EventListener)socketListener);
    }

    public void removeSocketListener(SocketListener socketListener) {
        this.listenerList.remove(Class.forName("net.eggdrop.jet.event.SocketListener"), (EventListener)socketListener);
    }

    protected void fireSocket(int n, String string) {
        Object[] objectArray = this.listenerList.getListenerList();
        SocketEvent socketEvent = new SocketEvent(this, n, string);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != Class.forName("net.eggdrop.jet.event.SocketListener")) continue;
            ((SocketListener)objectArray[i + 1]).socketMessage(socketEvent);
        }
    }

    public void run() {
        while (this.connected) {
            try {
                String string = this.is.readLine();
                boolean bl = this.connected = string != null;
                if (!this.connected) continue;
                this.fireSocket(2, string);
            }
            catch (IOException iOException) {
                this.connected = false;
            }
        }
        this.fireSocket(0, null);
    }
}

