/*
 * Decompiled with CFR 0.152.
 */
package net.eggdrop.jet.module;

import com.oroinc.text.regex.MalformedPatternException;
import com.sun.java.swing.event.EventListenerList;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventListener;
import net.eggdrop.jet.Client;
import net.eggdrop.jet.event.MessageEvent;
import net.eggdrop.jet.event.MessageListener;
import net.eggdrop.jet.event.ModuleEvent;
import net.eggdrop.jet.util.MessageParser;

public class ModuleBase {
    protected MessageParser moduleParser;
    private EventListenerList modListenerList;
    private EventListenerList cliListenerList = new EventListenerList();

    public ModuleBase() {
        this.modListenerList = new EventListenerList();
        this.moduleParser = new MessageParser();
    }

    public String moduleName() {
        return "unknown";
    }

    public final MessageParser moduleParser() {
        return this.moduleParser;
    }

    public void initModule() {
        try {
            this.moduleParser.addPattern(0, ".*");
        }
        catch (MalformedPatternException malformedPatternException) {
            System.err.println(malformedPatternException);
            System.exit(-1);
        }
    }

    public MessageEvent timeStamp(MessageEvent messageEvent) {
        if (Client.TIME_STAMP) {
            messageEvent.setMessage(String.valueOf(new SimpleDateFormat("HH:mm ").format(new Date())).concat(String.valueOf(messageEvent.getMessage())));
        }
        return messageEvent;
    }

    public void echoMessage(MessageEvent messageEvent) {
        if (Client.ECHO) {
            this.fireModuleMessage(this.timeStamp(new MessageEvent(messageEvent.getSource(), messageEvent.getId(), messageEvent.getMessage())));
        }
    }

    public void clientMessage(MessageEvent messageEvent) {
        this.echoMessage(messageEvent);
        this.fireClientMessage(messageEvent);
    }

    public void moduleMessage(ModuleEvent moduleEvent) {
        this.fireModuleMessage(this.timeStamp(moduleEvent));
    }

    public final void addClientMessageListener(MessageListener messageListener) {
        this.cliListenerList.add(Class.forName("net.eggdrop.jet.event.MessageListener"), (EventListener)messageListener);
    }

    public final void removeClientMessageListener(MessageListener messageListener) {
        this.cliListenerList.remove(Class.forName("net.eggdrop.jet.event.MessageListener"), (EventListener)messageListener);
    }

    protected final void fireClientMessage(MessageEvent messageEvent) {
        Object[] objectArray = this.cliListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != Class.forName("net.eggdrop.jet.event.MessageListener")) continue;
            ((MessageListener)objectArray[i + 1]).message(messageEvent);
        }
    }

    public final void addModuleMessageListener(MessageListener messageListener) {
        this.modListenerList.add(Class.forName("net.eggdrop.jet.event.MessageListener"), (EventListener)messageListener);
    }

    public final void removeModuleMessageListener(MessageListener messageListener) {
        this.modListenerList.remove(Class.forName("net.eggdrop.jet.event.MessageListener"), (EventListener)messageListener);
    }

    protected final void fireModuleMessage(MessageEvent messageEvent) {
        Object[] objectArray = this.modListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != Class.forName("net.eggdrop.jet.event.MessageListener")) continue;
            ((MessageListener)objectArray[i + 1]).message(messageEvent);
        }
    }
}

