##########################################################################
# JeggLink.tcl  Goes with JeggLink.class  v1.2                           #
#                                                                        #
# By Pierre-Mikael Legris plegris@fbwww.epfl.ch                          #
#                                                                        #
# This script was tested only on 1.0 and 1.2 versions of eggdrops        #
##########################################################################

## Set the Name of the channel were the eggdrop is 
set Pchannel "#jegg"

## Set the Defautl topic of this channel
set DTopic "JeggLink!"

## Set the URL of your page JeggLink
set URLJ "http://the.url.to/JeggLink.html"

############ DIFFERENT VERSION SUPPORT ############################
## the folowing line try to extract the version of your bot
## if you have a message such as "you are not running an eggdrop v1.2 ....
## maybe you would like to specify manually the version of your bot
## replace the folowing line if needed
## if you are running an eggdrop v1.2 or later try : set Jvers 2
## if you are running an eggdrop v1.0 try : set Jvers 1
## if you are running an eggdrop v1.1 i dunno try to find out

set Jvers [lindex [split $version "."] 1]


############ NOTHING NEED TO BE EDITED BELOW THIS LINE ###################



bind ctcp - "ACTION" cact
proc cact {nick uhost handle dest key text} {
    dccputchan 1 "ACT $nick $text"
}

bind dcc - wact w_act
proc w_act {handle idx text} {
    global Pchannel
    putserv "PRIVMSG $Pchannel :*$text"
    dccputchan 1 "ACT $text"
}

bind chat - * forward
proc forward {nick chan text} {
    global Pchannel 
    if {($chan == 1 )} {
	putserv "PRIVMSG $Pchannel :<[lindex $text 2]> [lrange $text 3 end]"
    }
}


bind pubm - * repeat
proc repeat {nick uhost handle channel text} {
    global botnick
    if { $nick != $botnick } {
	dccputchan 1 "SAY $nick $text"
    }
}

bind join - * ujoin
proc ujoin {nick uhost handle channel} {
    global botnick
    if { $nick == $botnick } {
	nuli
    } else {
    dccputchan 1 "JOI $nick $uhost"
    }
}

bind part - * upart
proc upart {nick uhost handle channel} {
    global botnick
    if { $nick == $botnick } {
	nuli
    } else {
	dccputchan 1 "PAR $nick"
    }
}

bind kick - * ukick
proc ukick {nick uhost handle chan knick reason} {
    dccputchan 1 "PAR $knick"
}

bind sign - * usign
proc usign {nick uhost handle channel reason} {
    dccputchan 1 "PAR $nick"
}

bind nick - * cnick
proc cnick {nick uhost handle channel newnick} {
    dccputchan 1 "NIC $nick $newnick"
}

bind dcc - ulist user_list
proc user_list {handle idx arg} {
    global Pchannel Uidx  
    putdcc $idx "*** ULI [chanlist $Pchannel] [wulist 0]"
}

proc nuli {} {
    global Pchannel
    dccputchan 1 "ULI [chanlist $Pchannel] [wulist 0]"
}


proc wulist { wul } {
    global Uidx
    set dccli [dcclist]
    set tmp ""
    foreach arg $dccli {
	    set uidxc [lindex $arg 0]
	if {([getchan $uidxc] == 1) && ([array get Uidx $uidxc] != "") } {
	    if {$wul == 0 } {
		set Uidu [lindex $Uidx($uidxc) 0]
	    } else {
		set Uidu "[lindex $Uidx($uidxc) 0]:[lindex $Uidx($uidxc) 1]"
	    }
	    set tmp "$tmp $Uidu"
	}
    }
    return $tmp
}

bind msg o !who RCwww
proc RCwww {nick uhost handle text} { Cwww $nick $uhost $handle QWERTY $text}

bind pub - !who Cwww 
proc Cwww {nick uhost handle channel text} {
    global Pchannel URLJ
    putserv "PRIVMSG $nick : $URLJ"
    putserv "PRIVMSG $nick : Users on the JeggLink:"
    foreach arg [wulist 1] {
	putserv "PRIVMSG $nick : $arg"
    }
    putserv "PRIVMSG $nick : End of !who"
}

bind msg o !kick MWebKick
bind msg o !k MWebKick
proc MWebKick {nick uhost handle text} {WebKick $nick $uhost $handle QWERTY $text}

bind pub o !kick WebKick
bind pub o !k WebKick
proc WebKick {nick uhost handle channel text} {
    global Pchannel
    set WGK [lindex $text 0]
    set REA [lrange $text 1 end]
    set JFound [lindex [verifkb $WGK] 0]
    if { $JFound != ""} {
	dccputchan 1 "WCK $WGK $nick : $REA"
	putserv "PRIVMSG $Pchannel : *** $nick Kicked $text"
    } else {
	putserv "PRIVMSG $nick : I don't know [lindex $text 0] , be sure that you typed '!k lamer(web)' to kick lamer"
    }
}

bind msg o !ban MWebBan
proc MWebBan {nick uhost handle text} {WebBan $nick $uhost $handle QWERTY $text}

bind pub o !ban WebBan
proc WebBan {nick uhost handle channel text} {
    global Pchannel
    set WGK [lindex $text 0]
    set JFound [verifkb $WGK]
    if { $JFound != ""} {
	putlog "$JFound"
	putserv "PRIVMSG $Pchannel : *** $nick : *!*@[lindex $JFound 1] +webban "
	dccputchan 1 "SAY *** $nick banned $WGK"
	dccputchan 1 "WCK $WGK $nick : banned!"
	putlog "*!*@[lindex $JFound 1]  placed on ignore"
	newignore "*!*@[lindex $JFound 1]" $handle "web ban"
    }   else {
	putserv "PRIVMSG $nick : I don't know [lindex $text 0] , be sure that you typed '!ban lamer(web)' to ban lamer"
    }
}

bind msg o !uban MWebUBan
proc MWebUBan {nick uhost handle text} {WebUBan $nick $uhost $handle QWERTY $text}

bind pub o !uban WebUBan
proc WebUBan {nick uhost handle channel text} {
    if { [killignore $text] } {
	putlog "$text isn't ignored anymore"
	putserv "PRIVMSG $nick : $text isn't ignored anymore"
    } else {
	putserv "PRIVMSG $nick : $text isn't ignored, the command is !uban <host> , use !banlist to see what hosts are ignored"
    }
}


bind msg o !banlist MWebLBan
proc MWebLBan {nick uhost handle text} {WebLBan $nick $uhost $handle QWERTY $text}

bind pub o !banlist WebLBan
proc WebLBan {nick uhost handle channel text} {
    set tmp ""
    foreach ignore [ignorelist] {
	set tmp "$tmp ; [lindex $ignore 0]"
    }
    if {$tmp != ""} {
	putserv "PRIVMSG $nick : BANLIST: $tmp"
    } else {
	putserv "PRIVMSG $nick : no ignores"
    }
}

proc verifkb {WGK} {
    global Uidx Pchannel
    set JFound ""
    foreach arg [dcclist] {
	if {[lindex $arg 1] == "www"} {  
	    set uidxc [lindex $arg 0] 
	    if { $WGK == [lindex $Uidx($uidxc) 0]} {
		set JFound "$Uidx($uidxc) $uidxc"
	    }
	}
    }
    return $JFound   
}


bind dcc - wjoin web_join
proc web_join {handle idx arg} {
    global Uidx Pchannel DTopic Jvers
    set dccl [dcclist]
    set InetA ""
    foreach dcca $dccl {
	if {[lindex $dcca 0] == $idx } {
	    if {$Jvers == "2"} {
		set InetA [lindex [lindex [split $dcca ":"] 1] 0]
	    } else {
		set InetA [lindex [lindex $dcca 2] 1]
	    }
	}
    }
    if {$handle == "www" } {
	set Uidx($idx)  "$arg $InetA"
	putserv "PRIVMSG $Pchannel : *** $arg $InetA joined"
	dccputchan 1 "JOI $arg $InetA"
    }
    putdcc $idx "*** TOP $Pchannel : $DTopic"
}

bind dcc - wcnic w_cnic
proc w_cnic {handle idx arg} {
    global Uidx Pchannel
    if {$handle == "www" } {
	set Onick [lindex $Uidx($idx) 0]
	set InetA [lindex $Uidx($idx) 1]
	set Uidx($idx) "$arg $InetA"
	putserv "PRIVMSG $Pchannel : *** $Onick changed his nick to : $arg"
	dccputchan 1 "NIC $Onick $arg"
    }
}

bind dcc - wwhois w_whois
proc w_whois {handle idx arg} {
    global Uidx Pchannel
    set web ""
    foreach wuser [wulist 1] {
	set wwuser [lindex [split $wuser ":"] 0]
	if {$wwuser == $arg} {
	    putdcc $idx "*** SAY - $wwuser : www@[lindex [split $wuser ":"] 1]"
	    set web "ZOB"
	}
    }
    if {$web == ""} {
	set wisop ""
	if {[isop $arg $Pchannel]} {
	    set wisop " (is an op)"
	}
	putdcc $idx "*** SAY - $arg : [getchanhost $arg $Pchannel] $wisop"
    }
}


bind chof - * chatoff
proc chatoff {handle idx } {
    global Uidx Pchannel
    if {$handle == "www" } {
	set Upart "$Uidx($idx)"
	set Uidx($idx) ""
	putserv "PRIVMSG $Pchannel : *** $Upart has left"
	dccputchan 1 "PAR $Upart"
    }
}

bind topc - * ctopc
proc ctopc { nick uhost handle channel topic} {
    global Pchannel DTopic
    dccputchan 1 "TOP $Pchannel : $topic"
    set DTopic $topic
}


putlog "JeggLink.tcl loaded"
putlog "eggdrop v 1.$Jvers detected"
if {($Jvers != "2")} {
    putlog "You are running not running an eggdrop v1.2*, if your bot is a v1.0* ignore this message, this version hasn't been tested with JeggLink \n
please repport to plegris@fbwww.epfl.ch if it works or not :o)"
}














