###############################################################################
#													#
# trivia.tcl 2.1     original (1.0) TCL script (c) 1.0 1997 by Tobias Begalke	#
#					email: tsbegalk@cip.informatik.uni-erlangen.de	#
#													#
#					Heavily modified and improved by Larry Cloud	#
#					email: larrycloud@hotmail.com				#
#													#
#													#
#   You can get the latest versions of the script and soundfiles from:		#
#													#
#	Script:  http://www2.whidbey.net/cloud/trivia2.zip				#
#	Soundfiles: http://www2.whidbey.net/cloud/trivwavs.zip			#
#													#
#													#
# An irc trivia game. For use with eggdrop bots v1.0 and newer.			#
# 													#
# the users on a channel can start a new game by typing "!trivia [number]	#
# [number]	is optional! without number, the number of points needed to win	#
# 		a match is $to_win (see below)						#
# options include: "zz" (or your command, simply change "command" below)	#
#                   followed by								#
#   help            : show commands and options						#
#   join team 1     : by typing this command, the user joins team 1		#
#   join team 2     : by typing this command, the user joins team 2		#
#   show teams      : shows who's on which team						#
#   team <name>     : sets name of the team the user is on to <name>		#
#   show comment    : displays the current question to the channel		#
#   show points     : displays the points of each team				#
#   rounds          : displays the number of rounds needed to win a match	#
#   list topics     : Show available game topics					#
#   select topic x  : Choose the game theme from the list described above	#
#   quit            : abort a running game without a result				#
#													#
#-----------------------------------------------------------------------------#
#  This program is free software; you can redistribute it and/or modify it	#
#  under the terms of the GNU General Public License as published by the	#
#  Free Software Foundation; either version 2 of the License, or (at your	#
#  option) any later version.									#
#													#
#  This program is distributed in the hope that it will be useful, but		#
#  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY	#
#  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License	#
#  for more details.										#
#													#
#  You should have received a copy of the GNU General Public License along	#
#  with this program; if not, write to the Free Software Foundation, Inc.,	#
#  675 Mass Ave, Cambridge, MA 02139, USA.						#
#													#
###############################################################################


#############################################################
# some global variables - these are the ones you can change #
#############################################################

set triv_botowners_nick "Larry"		;# Change this to your nick you use
set triv_cheat 1					;# 1 or 0 - if 1, and the owner (above) is playing, it will NOTE you with the answer [ for troubleshooting purposes only :) ]
set triv_command zz				;# Command which prededes everything concerning the game; change it to whatever you prefer.
set triv_to_win 5					;# Default number of points needed to win a match.
set triv_intervall_s 40				;# Time from question to result (seconds).
set triv_intervall_q 10				;# Time from result to next question (seconds).
set triv_sounds_on 1				;# Set to 0 if you don't want bot to use WAV files for sounds in game.

# If you come up with new question banks, just edit the below lines to reflect the theme and actual filename in your shell.
# If you DO add more, be sure to change the next variable to equal the number of banks you are using.
# If you want to use ONLY the default question bank, you would set the next variable to 1.
set triv_numbanks 4

# Now the filename for each bank, and the name shown in the "zz list topics" command.
set triv_fname_1 fragen				;# I left the default bank name as "fragen" so you can use the original bank
set triv_sname_1 "Default Question Bank"

# Additional Ones
set triv_fname_2 fragen.idiot
set triv_sname_2 "Trivia Idiots Question Bank"
set triv_fname_3 fragen.grabbag
set triv_sname_3 "Grab Bag Question Bank"
set triv_fname_4 fragen.cartoons
set triv_sname_4 "Cartoons & Comics Question Bank"
set triv_fname_5 fragen.adults
set triv_sname_5 "Adults Only Question Bank"

###################################################################
# NOTE:  Theres only code in place for up to a maximum of 5 banks #
# - don't go over that :) Also - even if you don't HAVE 5 banks,  #
# these need to be defined, so don't cut them out!  Also note,    #
# that these are examples, you can use or change them at your     #
# discretion - and no, I never made an "Adults Only" question     #
# bank :)  Its an EXAMPLE :) Only banks 1-triv_numbanks are		#
# listed so it won't show all 5 names if you don't have 5 of them #
# defined.  If you choose to thow out all but the default bank,	#
# the rest won't even be shown.						#
###################################################################


# Don't change anything below here, except where indicated, under penalty of death.  Changable items are denoted by #>>>changable

set trivia_in_process 0		;# indicates if there's a running game
set triv_team_1 {}		;# list of team-1-members
set triv_team_2 {}		;# list of team-2-members
set triv_teamname_1 {Team #1}	;# name of team 1
set triv_teamname_2 {Team #2}	;# name of team 2
set triv_points_1 0		;# points for team 1
set triv_points_2 0		;# points for team 2
set triv_q_timer 0		;# timerID for the question
set triv_q_index -1		;# index for selection of a question
set triv_team_c 0			;# team nr. of the team who found an answer
set triv_found 0			;# indicates if an answer was already found by a user
set triv_nick_c Nobody		;# the nick of the one who found the answer
set triv_earlier_q {}		;# list of earlier questions
set triv_amount_q 0		;# amount of questions already asked
set triv_question ""
set triv_answer ""
set triv_regexp ""
set triv_author "4 Larry Cloud 6 (larrycloud@hotmail.com)." ;# No reason to change this one :)
set triv_cheating 0
set trivia_in_progress 0      ;# flag used to prevent changing topics once game has begun.
set triv_fname $triv_fname_1
set triv_sname $triv_sname_1
set triv_num_play 0


###########################
# Some aliases for output #
###########################

proc putchan {chan what} { putserv "privmsg $chan :12 $what" }
proc putmsg {nick msg} { putserv "privmsg $nick :13 $msg" }
proc putnot {nick msg} { puthelp "NOTICE $nick :13 $msg" }
proc putsoundc {chan what} {putserv "PRIVMSG $chan :\1SOUND $what\1"}
proc putsoundn {nick what} {putserv "PRIVMSG $nick :\1SOUND $what\1"}

######################
# Set a new teamname #
######################

proc triv_set_teamname {nick name} {
 global triv_team_1 triv_team_2 triv_teamname_1 triv_teamname_2
  if {[string trim $name] == ""} { return 0 }
  if {[lsearch $triv_team_1 $nick] != -1} {
   set triv_teamname_1 [string trim $name]
    } elseif {[lsearch $triv_team_2 $nick] != -1} {
	set triv_teamname_2 [string trim $name] }
    return 0
}

###############
# Join team 1 #
###############

proc triv_join_team_1 {nick} {
global triv_team_1 triv_team_2 triv_teamname_1 triv_teamname_2
global triv_cheating triv_cheat triv_botowners_nick triv_sounds_on
 set i [lsearch $triv_team_2 $nick]
 if { $i != -1 } {
  set triv_team_2 [lreplace $triv_team_2 $i $i] }
  set i [lsearch $triv_team_1 $nick]
  if { $i == -1 } {
   set triv_team_1 [concat $triv_team_1 $nick] }
    putnot $nick "Joined Team 1, $triv_teamname_1"
 if { $triv_sounds_on == 1 } {
 putsoundn $nick "jt1.wav says joined team 1"
}
 if  { [string match $nick $triv_botowners_nick] == 1} {
  if { $triv_cheat == 1 } {
   set triv_cheating 1 }
  }
   return 0
}

###############
# Join team 2 #
###############

proc triv_join_team_2 {nick} {
global triv_team_1 triv_team_2 triv_teamname_1 triv_teamname_2
global triv_cheating triv_cheat triv_botowners_nick triv_sounds_on
 set i [lsearch $triv_team_1 $nick]
 if { $i != -1 } {
  set triv_team_1 [lreplace $triv_team_1 $i $i] }
  set i [lsearch $triv_team_2 $nick]
  if { $i == -1 } {
   set triv_team_2 [ concat $triv_team_2 $nick ] }
   putnot $nick "Joined Team 2, $triv_teamname_2"
if { $triv_sounds_on == 1 } {
 putsoundn $nick "jt2.wav says joined team 2"
}
if  { [string match $nick $triv_botowners_nick] == 1} {
  if { $triv_cheat == 1 } {
   set triv_cheating 1 }
  }
   return 0
}

#################################################
# Show team members and persons not on any team #
#################################################

proc triv_show_teams {chan} {
global triv_team_1 triv_team_2 triv_teamname_1 triv_teamname_2 botnick
set users [chanlist $chan]
 set i [lsearch $users $botnick]
 set users [lreplace $users $i $i]
 foreach value $triv_team_1 {
 if {[onchan $value $chan] != 1} {
  set i [lsearch $triv_team_1 $value]
  set triv_team_1 [lreplace $triv_team_1 $i $i]
 }
} 
foreach value $triv_team_2 {
 if {[onchan $value $chan] != 1} {
 set i [lsearch $triv_team_2 $value]
 set triv_team_2 [lreplace $triv_team_2 $i $i]
 }
}
foreach value $triv_team_1 {
 set i [lsearch $users $value]
 set users [lreplace $users $i $i]
 }
foreach value $triv_team_2 {
 set i [lsearch $users $value]
 set users [lreplace $users $i $i]
 }
putchan $chan " On no team :  $users"
putchan $chan " On $triv_teamname_1 :  $triv_team_1"
putchan $chan " On $triv_teamname_2 :  $triv_team_2"
return 0
}


#########################################################################
# Show available topics / themes (make sure you added them at the top!) #
#########################################################################

proc triv_list_topics {chan} {
global triv_sname_1 triv_sname_2 triv_sname_3
global triv_sname_4 triv_sname_5 triv_numbanks triv_command
putchan $chan " Number  Topic / Theme"
putchan $chan "    1.      :  $triv_sname_1"
if { $triv_numbanks >= 2 } {
putchan $chan "    2.      :  $triv_sname_2"
}
 if { $triv_numbanks >= 3 } {
putchan $chan "    3.      :  $triv_sname_3"
}
 if { $triv_numbanks >= 4 } {
putchan $chan "    4.      :  $triv_sname_4"
}
 if { $triv_numbanks >= 5 } {
putchan $chan "    5.      :  $triv_sname_5"
}
putchan $chan " Topics are selected by using \"$triv_command select topic x\" where x a number from 1 to $triv_numbanks, from the list above."
return 0
}


##################
#Selects topic 1 #
##################

proc triv_sel_topic_1 {chan nick} {
global triv_numbanks trivia_in_progress triv_fname triv_fname_1
global triv_sname triv_sname_1 triv_sounds_on
if { $triv_numbanks < 1 } {
putchan $chan "Sorry, I don't have that many question banks."
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "ntm.wav says don't have that many question banks."
 }
} elseif { $trivia_in_progress == 0 } {
set triv_fname $triv_fname_1
set triv_sname $triv_sname_1
putchan $chan "Topic 1, $triv_sname, selected by $nick."
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "t1s.wav says topic 1 selected."
 }
} else {
putchan $chan "Sorry, can't change topics once the game has begun!"
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "cht.wav says can't change topics now."
 }
}
return 0
}

##################
#Selects topic 2 #
##################

proc triv_sel_topic_2 {chan nick} {
global triv_numbanks trivia_in_progress triv_fname triv_fname_2
global triv_sname triv_sname_2 triv_sounds_on
if { $triv_numbanks < 2 } {
putchan $chan "Sorry, I don't have that many question banks."
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "ntm.wav says don't have that many question banks."
 }
} elseif { $trivia_in_progress == 0 } {
set triv_fname $triv_fname_2
set triv_sname $triv_sname_2
putchan $chan "Topic 2, $triv_sname, selected by $nick." 
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "t2s.wav says topic 2 selected."
 }
 } else {
putchan $chan "Sorry, can't change topics once the game has begun!"
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "cht.wav says can't change topics now."
 }
}
return 0
}

##################
#Selects topic 3 #
##################

proc triv_sel_topic_3 {chan nick} {
global triv_numbanks trivia_in_progress triv_fname triv_fname_3
global triv_sname triv_sname_3 triv_sounds_on
if { $triv_numbanks < 3 } {
putchan $chan "Sorry, I don't have that many question banks."
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "ntm.wav says don't have that many question banks."
 }
 } elseif { $trivia_in_progress == 0 } {
set triv_fname $triv_fname_3
set triv_sname $triv_sname_3
putchan $chan "Topic 3, $triv_sname, selected by $nick."
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "t3s.wav says topic 3 selected."
 }
 } else {
putchan $chan "Sorry, can't change topics once the game has begun!"
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "cht.wav says can't change topics now."
 }
}
return 0
}

##################
#Selects topic 4 #
##################

proc triv_sel_topic_4 {chan nick} {
global triv_numbanks trivia_in_progress triv_fname triv_fname_4
global triv_sname triv_sname_4 triv_sounds_on
if { $triv_numbanks < 4 } {
putchan $chan "Sorry, I don't have that many question banks."
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "ntm.wav says don't have that many question banks."
 }
 } elseif { $trivia_in_progress == 0 } {
set triv_fname $triv_fname_4
set triv_sname $triv_sname_4
putchan $chan "Topic 4, $triv_sname, selected by $nick." 
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "t4s.wav says topic 4 selected."
 }
 } else {
putchan $chan "Sorry, can't change topics once the game has begun!"
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "cht.wav says can't change topics now."
 }
}
return 0
}

##################
#Selects topic 5 #
##################

proc triv_sel_topic_5 {chan nick} {
global triv_numbanks trivia_in_progress triv_fname triv_fname_5
global triv_sname triv_sname_5 triv_sounds_on
if { $triv_numbanks < 5 } {
putchan $chan "Sorry, I don't have that many question banks."
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "ntm.wav says don't have that many question banks."
 }
 } elseif { $trivia_in_progress == 0 } {
set triv_fname $triv_fname_5
set triv_sname $triv_sname_5
putchan $chan "Topic 5, $triv_sname, selected by $nick." 
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "t5s.wav says topic 5 selected."
 }
 } else {
putchan $chan "Sorry, can't change topics once the game has begun!"
 if { $triv_sounds_on == 1 } {
 putsoundc $chan "cht.wav says can't change topics now."
 }
}
return 0
}

#############################
# The actual main procedure #
#############################

proc triv_game {nick uhost hand chan args} {
global trivia_in_process triv_team_1 triv_team_2 triv_q_index 
global triv_team_c triv_found triv_points_1 triv_points_2 
global triv_q_timer botnick triv_teamname_1 triv_teamname_2 triv_amount_q
global triv_answer triv_command triv_question triv_to_win
global triv_question triv_regexp triv_list_topics triv_fname
global triv_sname triv_numbanks triv_fname_1 triv_fname_2
global triv_fname_3 triv_fname_4 triv_fname_5 triv_sname_1
global triv_sname_2 triv_sname_3 triv_sname_4 triv_sname_5
global trivia_in_progress triv_nick_c triv_botowners_nick
global triv_sounds_on

set rest [string tolower $args]
set rest [string trim $rest \{\}\ ]
if { [string match {help} $rest] == 1 } {
putmsg $nick " Available commands for this game are $triv_command followed by: "
putmsg $nick " help  shows this help"
putmsg $nick " join team 1  lets you join team #1"
putmsg $nick " join team 2  see above"
putmsg $nick " show teams  shows, who's on a team currently"
putmsg $nick " team <new name>  changes your team's name to <new name>"
putmsg $nick " show points  displays the points of each team"
putmsg $nick " show comment  redisplays the current question"
putmsg $nick " rounds  show number of rounds needed to win"
putmsg $nick " list topics  lists out the verious topics for the game"
putmsg $nick " select topic x  (use a number for x from the show topics command above) chooses a theme for the game."
putmsg $nick " quit  ends the current game immediately"
putmsg $nick " to answer a question, type \"$triv_command <your answer>\""
} elseif { [string match {show teams} $rest] == 1 } {
triv_show_teams $chan 
} elseif { [string match {join team 1} $rest] == 1 } {
triv_join_team_1 $nick
} elseif { [string match {list topics} $rest] == 1 } {
triv_list_topics $chan 
} elseif { [string match {select topic 1} $rest] == 1 } {
triv_sel_topic_1 $chan $nick
} elseif { [string match {select topic 2} $rest] == 1 } {
triv_sel_topic_2 $chan $nick
} elseif { [string match {select topic 3} $rest] == 1 } {
triv_sel_topic_3 $chan $nick
} elseif { [string match {select topic 4} $rest] == 1 } {
triv_sel_topic_4 $chan $nick
} elseif { [string match {select topic 5} $rest] == 1 } {
triv_sel_topic_5 $chan $nick
} elseif { [string match {join team 2} $rest] == 1 } {
triv_join_team_2 $nick
} elseif { [string match {rounds} $rest] == 1 } {
putchan $chan " $triv_to_win  rounds needed to win."
} elseif { [string match {team?*} $rest] == 1 } {
set name [string trim $args \{\}\ ]
set name [lrange $name 1 end]
triv_set_teamname $nick $name
} elseif { [string match {show comment} $rest] == 1 } {
if { $triv_q_index < 0 } { return 0 }
putchan $chan " Under the topic: $triv_sname, the current question is: $triv_question"
} elseif { [string match {quit} $rest] == 1 } {
killutimer $triv_q_timer
set trivia_in_process 0
set triv_points_1 0
set triv_points_2 0
set triv_found 0
set triv_team_1 {}
set triv_team_2 {}
set triv_team_c 0
set triv_question ""
set triv_answer ""
set triv_regexp ""
set triv_fname $triv_fname_1
set triv_sname $triv_sname_1
bind pub - $triv_command triv_no_game_yet
putchan $chan "ATTENTION! $nick has cancelled the current game! "
if { $triv_sounds_on == 1 } {
putsoundc $chan "endgame.wav says this game has been cancelled."
}
return 0
} elseif { [string match {show points} $rest] == 1 } {
putchan $chan " $triv_teamname_1: $triv_points_1, $triv_teamname_2: $triv_points_2 "
} else {
if { $triv_q_index < 0 } { return 0 }
set ans_search $triv_regexp
set ans_search [string tolower $ans_search]
if { $triv_found != 0 } {
return 0
}
if { [string match $ans_search $rest] == 1} {
if { [lsearch $triv_team_1 $nick] >= 0 } {
set triv_found 1
set triv_nick_c $nick
set triv_team_c 1
killutimer $triv_q_timer
triv_show $chan
} elseif { [lsearch $triv_team_2 $nick] >= 0 } {
set triv_found 1
set triv_nick_c $nick
set triv_team_c 2
killutimer $triv_q_timer
triv_show $chan
} else { return 0 }
} }
 return 0
}

#############################################################
# this procedure starts the game and initializes everything #
#############################################################

proc triv_startup {nick uhost hand chan args} {
global trivia_in_process triv_points_1 triv_points_2 triv_to_win
global triv_team_1 triv_team_2 triv_command triv_earlier_q triv_amount_q
global triv_teamname_1 triv_teamname_2 triv_q_timer no_questions 
global a_timer triv_nick_c botnick triv_team_c triv_intervall_q 
global trivia_in_progress triv_fname triv_sname triv_cheating
global triv_botowners_nick triv_cheat triv_sounds_on
if { $trivia_in_process != 0 } { ;# do nothing if a game is already running
putnot $nick "Game in progress! Join a team please, or type $triv_command help for help."
return 0
}
set trivia_in_process 1
set trivia_in_progress 0
set triv_nick_c Nobody
bind pub - $triv_command triv_game
# set triv_earlier_q {}  ;#>>>changable   unmark these 2 lines, if you want the complete
# set triv_amount_q 0    ;#>>>changable   set of questions each game
set triv_team_1 {}
set triv_team_2 {}
set triv_team_c 0
set triv_teamname_1 {Team #1}
set triv_teamname_2 {Team #2}
set triv_cheating 0
set arg [string trim $args \{\}\ ]
if { ($arg != {}) && ($arg <= 25) && ($arg > 0) } {
set triv_to_win $arg
} elseif { ($arg != {}) && ($arg > 0) } {
set triv_to_win 10
} else { set triv_to_win 3 }
set triv_q_timer [utimer 69 "triv_ask $chan"]
if { $triv_sounds_on == 1 } {
putsoundc $chan "start.wav says we have started a new game of trivia!"
}
putchan $chan " This is $botnick, your $chan trivia bot... this trivia game brought to you by that nice person, $triv_botowners_nick! "
putchan $chan " Starting a new game. $triv_to_win points (correct answers) needed to win. "
putchan $chan " Players please join a team now by typing \"$triv_command join team 1\" or \"$triv_command join team 2\""
putchan $chan " To answer a question, type \"$triv_command <your answer>\""
putchan $chan " Remember you can now choose a topic for the questions!  Available topic are:"
triv_list_topics $chan
putchan $chan " Type \"$triv_command help\" for help. "
putchan $chan " The game will begin in one minute so join a team and select a topic NOW!"
if { $triv_sounds_on == 1 } {
putsoundc $chan "letsgo.wav says lets go join a team!"
putchan $chan "You can get the soundfiles from:  http://www2.whidbey.net/cloud/trivwavs.zip"
}
return 0
}

######################################################################
# finds a question not yet asked in this round and returns its index #
######################################################################

proc triv_find_index {max} {
global triv_earlier_q triv_amount_q trivia_in_progress

set trivia_in_progress 1
if { $triv_amount_q >= $max } { 
set triv_earlier_q {}
set triv_amount_q 0
}
set i [rand $max]
while { [lsearch $triv_earlier_q $i] != -1 } { 
incr i
set i [expr $i % $max]
}
set triv_earlier_q [concat $triv_earlier_q $i]
incr triv_amount_q
return $i
}

######################################
# calculates and prints the question #
######################################

proc triv_ask {chan} {
global triv_team_1 triv_team_2 triv_question triv_q_index 
global triv_earlier_q triv_intervall_s triv_amount_q
global triv_points_1 triv_points_2 triv_to_win triv_q_timer triv_team_c 
global triv_question triv_answer triv_regexp triv_botowners_nick
global triv_fname triv_sname triv_cheat triv_cheating

if [ catch { open scripts/$triv_fname r } fileID ] {
putchan $chan "Can't open the questions file...exiting..."
putlog "Can't open the questions file: $fileID"
exit 1
} else {
set amount [ gets $fileID ]
set nr [ triv_find_index $amount ]
for { set i 0 } { $i < $nr } { incr i } {
gets $fileID
}
set line [ gets $fileID ]
set splitt [ split $line | ]
set triv_question [ lindex $splitt 0 ]
set triv_answer [ lindex $splitt 1 ]
set triv_regexp [ lindex $splitt 2 ]
close $fileID
}
set triv_team_c 0
set triv_found 0
set triv_q_index 1
set triv_in_progress 1
putchan $chan " Under the topic of:  $triv_sname ($amount questions in this bank)"
putchan $chan " The question is:  $triv_question"
if { $triv_cheating == 1 } {
putnot $triv_botowners_nick "PSST - the answer is: $triv_answer"
}
set triv_q_timer [utimer $triv_intervall_s "triv_show $chan"]
return 0
}

################################################
# shows the winning team and resets everything #
################################################

proc triv_win {team_no chan} {
global triv_team_1 triv_team_2 triv_points_1 triv_points_2 triv_nick_c 
global triv_author triv_command triv_botowners_nick
global triv_teamname_1 triv_teamname_2 triv_found trivia_in_process
global triv_fname triv_sname triv_fname_1 triv_sname_1
global triv_in_progress triv_sounds_on

if { $team_no == 1 } { ;# check which team wins
putchan $chan " $triv_teamname_1 (Team #1) wins the game!  Congratulations! "
if { $triv_sounds_on == 1 } {
putsoundc $chan "t1wins.wav says way to go team 1!"
}
} else {
putchan $chan " $triv_teamname_2 (Team #2) wins the game! Congratulations! "
if { $triv_sounds_on == 1 } {
putsoundc $chan "t2wins.wav says way to go team 2!"
}
}
if [ catch { open scripts/tr_prizes r } fileID ] {
putlog "Can't open tr_prizes: $fileID"
} else {
set amount [ gets $fileID ]
set nr [ rand $amount ]
set nr [ rand $amount ]
for { set i 0 } { $i <= $nr } { incr i } {
set prize [ gets $fileID ]
}
close $fileID
if { $prize == "" } {
putchan $chan "Your prize is: Nothing, due to an error!"
} else {
putchan $chan "Your prize is:  $prize"
} }
putchan $chan "Brought to you by: $triv_author 3and 1$triv_botowners_nick3, owner of this bot."
putchan $chan " 1,1.2,2.3,3.4,4.5,5.6,6.7,7.8,8.9,9.10,10.11,11.12,12.13,13.14,14.15,15.8,1 Thats Game Folks! 15,15.14,14.13,13.12,12.11,11.10,10.9,9.8,8.7,7.6,6.5,5.4,4.3,3.2,2.1,1"
if { $triv_sounds_on == 1 } {
putsoundc $chan "theend.wav says game over folks."
}
bind pub - $triv_command triv_no_game_yet ;# reset all functions and vars
set triv_points_1 0
set triv_points_2 0
set triv_found 0
set trivia_in_process 0
set triv_nick_c Nobody
set triv_in_progress 0
set triv_fname $triv_fname_1
set triv_sname $triv_sname_1
set triv_numplay 0
return 0
}

########################################################
# prints the result of a round and terminates the game #
########################################################

proc triv_show {chan} {
global triv_nick_c triv_team_c triv_points_1 triv_points_2 triv_answer 
global triv_q_timer triv_intervall_q triv_teamname_2 triv_found triv_to_win
global triv_q_index triv_team_1 triv_team_2 triv_teamname_1
global triv_question triv_answer triv_regexp triv_sounds_on
set p_1 Points
set p_2 Points
set i $triv_q_index
set triv_q_index -1
set output $triv_answer
putchan $chan " Here's the result of this round: "
if { $triv_sounds_on == 1 } {
putsoundc $chan "answeris.wav says the answer is..."
}
putchan $chan " The correct answer was: $output"
if { $triv_team_c == 1 } {
incr triv_points_1
if { $triv_sounds_on == 1} {
putsoundc $chan "gjt1.wav says good job team 1!"
} 
putchan $chan " Found by $triv_nick_c -=$triv_teamname_1=- "
} elseif { $triv_team_c == 2 } {
incr triv_points_2
if { $triv_sounds_on == 1} {
putsoundc $chan "gjt2.wav says good job team 2!"
} 
putchan $chan " Found by $triv_nick_c -=$triv_teamname_2=- "
} else { putchan $chan " Found by $triv_nick_c" }
if { $triv_points_1 == 1 } { set p_1 Point }
if { $triv_points_2 == 1 } { set p_2 Point }
putchan $chan " $triv_teamname_1 : $triv_points_1 $p_1"
putchan $chan " $triv_teamname_2 : $triv_points_2 $p_2"
if { $triv_points_1 >= $triv_to_win } {
if { $triv_points_1 > $triv_points_2 } {
triv_win 1 $chan
return 0
} }
if { $triv_points_2 >= $triv_to_win } {
if { $triv_points_2 > $triv_points_1 } {
triv_win 2 $chan
return 0
} }
set triv_nick_c Nobody  ;# reset the adequate vars
set triv_found 0
set triv_q_timer [utimer $triv_intervall_q "triv_ask $chan"] ;# set timer for next question
return 0
}

###################################################################
# Some weenie tried a triv command when the game wasn't running!	#
# Actually this routine gets used at the end of the game if		#
# someone puts in an answer after the correct answer is given	#
# and its the last question of the game.					#
###################################################################

proc triv_no_game_yet {nick uhost hand chan args} {
putmsg $nick "There's no game running! Start one by typing !trivia x where x is a number between 1 and 25"
putmsg $nick "The number is optional.  To play a game with 10 points needed to win, type !trivia 10.  To play a game with 5 points needed to win, type !trivia 5."
return 0
}

###############################################################
# if a user changes nick, this procedure updates the teamlist #
###############################################################

proc triv_update_team {nick uhost handle chan newnick} {
global triv_team_1 triv_team_2 triv_nick_c
if { [string match $triv_nick_c $nick] == 1 } {
set triv_nick_c $newnick
}
if { [lsearch $nick $triv_team_1] >= 0 } {
set triv_team_1 [concat $triv_team_1 $newnick]
} elseif { [lsearch $nick $triv_team_2] >= 0 } {
set triv_team_2 [concat $triv_team_2 $newnick]
}
return 0
}


#############################
# Get the show on the road! #
#############################

bind pub - $triv_command triv_no_game_yet
bind pub - !trivia triv_startup
bind nick - * triv_update_team
putlog "Trivia 2.1 with sound by Larry Cloud - version date 05/09/98 -04:39am... loaded"
