bind pub o !help pub:help

proc pub:help {nick uhost hand chan args} {
  global botnick
  set hlp "[lindex $args 0]"
  if {$hlp == ""} {
    puthelp "NOTICE $nick :Commands you have access to."
    puthelp "NOTICE $nick :----------------------------"
    puthelp "NOTICE $nick : MSG Commands:"
    puthelp "NOTICE $nick : op        -- Tells the bot to op you."
    puthelp "NOTICE $nick : -"
    puthelp "NOTICE $nick : PUBLIC Commands:"
    puthelp "NOTICE $nick : !whois    -- Gives you that record's info."
    puthelp "NOTICE $nick : !unban    -- Unban a record that is on the bot."
    puthelp "NOTICE $nick : !userlist -- Gives you a list of users."
    if {[matchattr $hand m]} {
      puthelp "NOTICE $nick : !useradd  -- Adds a record to the bot."
      puthelp "NOTICE $nick : !userdel  -- Removes a record from the bot."
      puthelp "NOTICE $nick : !shitadd  -- Adds a shitlist record to the bot."
      puthelp "NOTICE $nick : !shitdel  -- Removes a shitlist record from the bot."
      puthelp "NOTICE $nick : !chattr   -- Changes a record's flags."
      puthelp "NOTICE $nick : !chanattr -- Changes a record's flags for the current channel."
      puthelp "NOTICE $nick : !ban      -- Ban all of a record's hosts from the channel."
      puthelp "NOTICE $nick : !hostadd  -- Add a host to which a record will be recognised as."
      puthelp "NOTICE $nick : !hostdel  -- Remove a host from a record."
    }
  }
  if {$hlp == "op"} {
    puthelp "NOTICE $nick : Command: op"
    puthelp "NOTICE $nick : Syntax : /msg $botnick op <pass>"
    puthelp "NOTICE $nick : ------------------"
    puthelp "NOTICE $nick : Use: This gets the bot to op you."
  }
  if {$hlp == "whois"} {
    puthelp "NOTICE $nick : Command: !whois"
    puthelp "NOTICE $nick : Syntax : !whois <record>"
    puthelp "NOTICE $nick : -----------------------"
    puthelp "NOTICE $nick : Use: Use this command to find out information on a user's"
    puthelp "NOTICE $nick :      record. This will display their record name, current name"
    puthelp "NOTICE $nick :      in the channel (if aviable), their channel flags and global"
    puthelp "NOTICE $nick :      flags, plus the hosts that the record is identifyed with."
  }
  if {$hlp == "unban"} {
    puthelp "NOTICE $nick : Command: !unban"
    puthelp "NOTICE $nick : Syntax : !unban <record>"
    puthelp "NOTICE $nick : ------------------------"
    puthelp "NOTICE $nick : Use: Use this command to unban all the addresses a user"
    puthelp "NOTICE $nick :      is known by. Useful to counteract a !ban"
  }
  if {$hlp == "ban"} {
    puthelp "NOTICE $nick : Command: !ban"
    puthelp "NOTICE $nick : Syntax : !ban <record/nick>"
    puthelp "NOTICE $nick : ---------------------------"
    puthelp "NOTICE $nick : Use: This command is useful to ban an entire record or a specific"
    puthelp "NOTICE $nick :      nickname from the channel. When used on a record it will ban"
    puthelp "NOTICE $nick :      all hosts that record is known by. When used on a nickname"
    puthelp "NOTICE $nick :      it will ban just that nickname from the channel."
  }
  if {$hlp == "useradd"} {
    puthelp "NOTICE $nick : Command: !useradd
    puthelp "NOTICE $nick : Syntax : !useradd <record> <mask>"
    puthelp "NOTICE $nick : ---------------------------------"
    puthelp "NOTICE $nick : Use: This will add a record to the bot with the supplied host"
    puthelp "NOTICE $nick :      mask. The flags set to this record are '$default-flags'."
    puthelp "NOTICE $nick :      once you add the record you should adjust their flags acor-"
    puthelp "NOTICE $nick :      dingly to fit to the access you want to give the record."
    puthelp "NOTICE $nick :      This is done with !chattr"
  }
  if {$hlp == "userdel"} {
    puthelp "NOTICE $nick : Command: !userdel"
    puthelp "NOTICE $nick : Syntax : !userdel <record>"
    puthelp "NOTICE $nick : --------------------------"
    puthelp "NOTICE $nick : Use: Use this command to remove a record from the bot."
  }
  if {$hlp == "chattr"} {
    puthelp "NOTICE $nick : Command: !chattr"
    puthelp "NOTICE $nick : Syntax : !chattr <record> <flags>"
    puthelp "NOTICE $nick : ---------------------------------"
    puthelp "NOTICE $nick : Use: This command modifys the record's flags of access. Every"
    puthelp "NOTICE $nick :      time this command is used it is writen into a log file."
    puthelp "NOTICE $nick :      DO NOT even think of abusing your access to this command."
    puthelp "NOTICE $nick :      The only flags that you should be changing are the"
    puthelp "NOTICE $nick :      flags 'p', 'o', and 'v'. If you are adding a user to"
    puthelp "NOTICE $nick :      the auto-voice then run a command like the following"
    puthelp "NOTICE $nick :      '!chattr user -p+v'. To add an op use a command like"
    puthelp "NOTICE $nick :      '!chattr user +o'. Any other uses for this command"
    puthelp "NOTICE $nick :      are to be left to the descretion of the owner of the bot."
  }
  if {$hlp == "chanattr"} {
    puthelp "NOTICE $nick : Command: !chanattr"
    puthelp "NOTICE $nick : Syntax : !chanattr <record> <flags>"
    puthelp "NOTICE $nick : -----------------------------------"
    puthelp "NOTICE $nick : Use: Basicly the same as !chattr but deals with channel specific"
    puthelp "NOTICE $nick :      commands."
  }
  if {$hlp == "shitadd"} {
    puthelp "NOTICE $nick : Command: !shitadd"
    puthelp "NOTICE $nick : Syntax : !shitadd <mask> <reason>"
    puthelp "NOTICE $nick : ---------------------------------"
    puthelp "NOTICE $nick : Use: This command is to be used in extreem cases only and"
    puthelp "NOTICE $nick :      each use is recorded to a log file. DO NOT ABUSE."
  }
  if {$hlp == "shitdel"} {
    puthelp "NOTICE $nick : Command: !shitdel"
    puthelp "NOTICE $nick : Syntax : !shitdel <mask>"
    puthelp "NOTICE $nick : ------------------------"
    puthelp "NOTICE $nick : Use: Removes a shitlist entry."
  }
  if {$hlp == "hostadd"} {
    puthelp "NOTICE $nick : Command: !hostadd"
    puthelp "NOTICE $nick : Syntax : !hostadd <record> <mask>"
    puthelp "NOTICE $nick : ---------------------------------"
    puthelp "NOTICE $nick : Use: This is only to be used to add a hostmask to a user who"
    puthelp "NOTICE $nick :      is not mentaly aware enough to use the 'ident' command."
  }
  if {$hlp == "hostdel"} {
    puthelp "NOTICE $nick : Command: !hostdel"
    puthelp "NOTICE $nick : Syntax : !hostdel <record> <mask>"
    puthelp "NOTICE $nick : ---------------------------------"
    puthelp "NOTICE $nick : Use: To remove a hostmask from a record."
  }
  if {$hlp == "userlist"} {
    puthelp "NOTICE $nick : Command: !userlist"
    puthelp "NOTICE $nick : Syntax : !userlist 'flags'"
    puthelp "NOTICE $nick : --------------------------"
    puthelp "NOTICE $nick : Use: This command will return a list of records with the"
    puthelp "NOTICE $nick :      specified flags. If no flags are given it will return all"
    puthelp "NOTICE $nick :      users."
  }
}

