bind pub m !useradd pub_adduser
bind pub m !userdel pub_deluser
bind pub m !chattr pub_chattr
bind pub m !chanattr pub_chanattr
bind pub m !hostadd pub_hostadd
bind pub m !hostdel pub_hostdel


proc pub_hostadd {nick uhost hand chan data} {
  set user "[lindex $data 0]"
  set umsk "[lindex $data 1]"
  if {$user == ""} {puthelp "NOTICE $nick :Syntax- !hostadd <handle> <mask>" ;return 1}
  if {$umsk == ""} {puthelp "NOTICE $nick :Syntax- !hostadd <handle> <mask>" ;return 1}
  addhost $user $umsk
  puthelp "NOTICE $nick :Added $umsk to $user's host list."
}

proc pub_hostdel {nick uhost hand chan data} {
  set user "[lindex $data 0]"
  set umsk "[lindex $data 1]"
  if {$user == ""} {puthelp "NOTICE $nick :Syntax- !hostdel <handle> <mask>" ;return 1}
  if {$umsk == ""} {puthelp "NOTICE $nick :Syntax- !hostdel <handle> <mask>" ;return 1}
  if {[delhost $user $umsk]} {
    puthelp "NOTICE $nick :Removed host $umsk from $user's host list."
  } else {
    puthelp "NOTICE $nick :ERROR- Either the handle or host specified is invalid. Please try again."
  }
}
 
proc pub_adduser {nick uhost hand chan data} {
  set user "[lindex $data 0]"
  set usrmsk "[lindex $data 1]"
  if {$user == ""} {puthelp "NOTICE $nick :Syntax- !useradd <handle> <mask>" ;return 1}
  if {$usrmsk == ""} {puthelp "NOTICE $nick :Snt׭ !useradd <hndle> <msk>" ;return 1}
  if {[adduser $user $usrmsk]} {
    puthelp "NOTICE $nick :Added $user to my database ( mask: $usrmsk )"
    setxtra $user "Added by $hand on $date"
    sendnote $hand "DeadWatch" "Added user $user to the bot on $date."
    return 1
  } else {
    puthelp "NOTICE $nick :ERROR- Could not add $user to database. Check for a previous use of that nickname or reffer to the syntax you used."
    return 1
  }
}
proc pub_deluser {nick uhost hand chan data} {
  set user "[lindex $data 0]"
  if {[deluser $user]} {
    puthelp "NOTICE $nick :Deleted record for $user"
    return 1
  } else {
    puthelp "NOTICE $nick :ERROR- a record for $user does not exist."
    return 1
  }
}
proc pub_chattr {nick uhost hand chan data} {
  set who "[lindex $data 0]"
  set attr "[lindex $data 1]"
  chattr $who $attr
  puthelp "NOTICE $nick :Flags for [lindex $data 0] are now [chattr $who]."
  return 1
}
proc pub_chanattr {nick uhost hand chan data} {
  set who "[lindex $data 0]"
  set attr "[lindex $data 1]"
  chattr $who $attr $chan
  puthelp "NOTICE $nick :Flags for [lindex $data 0] are now [chattr who $chan]."
  return 1
}

