# WhatIs? 1.0 by Brad Kaplan [mh.tric] -+- email: mh@tric.org
# -----------------------------------------------------------
# This TCL is based primarily on a subset of commands available on a
# lamerbawt. I've always wanted the same functionality on an eggdrop, but
# since nobody bothered to read my mind and write one, I finally broke down
# and wrote it myself. It essentially allows users (+o) to define words any
# way they see fit and to reverse the process (delete definitions, etc).
# Each word can have as many definitions as your disk space will allow.
# Masters can also lock/unlock definitions to prevent/allow them from being
# deleted.
#
# I don't have the time nor patience to go through and clean up the code, as
# far as I know, it's all fully functional, albeit sloppy. It is my first
# actual release (but not my first intended release), so you'll have to
# excuse any vulnerabilities in that respect. If you have any comments/
# suggestions/bug reports/etc, please feel free to email me at the above
# address.
#
# To Do:
# - Possible [optional] separate 'dictionaries' for each channel
# - Limit the number of definitions per word
#
# Release History:
# Version 1.0 - Released Monday, Sept. 29, 1997

# it was just easiest to store each word in its own files so this directory
# (relative to the eggdrop's directory) is where they will be stored). You
# will have to create this directory manually (and don't include a trailing
# slash).

set dictdir "./whatis"

##### DO NOT CHANGE BELOW ######

# Binds
bind pub -|- !helpdef pub_helpdef
bind pub -|- !whatis pub_getdef
bind pub o|o !define pub_setdef
bind pub o|o !remdef pub_remdef
bind pub m|m !whodef pub_whodef
bind pub m|m !deldef pub_deldef
bind pub m|m !lokdef pub_lockdef
bind pub m|m !ulkdef pub_unlockdef

proc pub_getdef {nick uhost hand chan arg} {
   global dictdir
   if {$arg == ""} {
      putserv "NOTICE $nick :\002usage\002\037:\037 !whatis <word>"
      return 0
      }
   set word [string tolower [lindex $arg 0]]
   if {![file exists $dictdir/$word.def]} {
      putserv "PRIVMSG $chan :unknown word\037:\037 \002$word\002"
   } else {
      set count "0"
      set df [open $dictdir/$word.def r]
      while {![eof $df]} {
        set def [gets $df]
        if {$def != ""} {
           incr count
           set def [lrange $def 1 end]
           if {[string index $def 0] == "@"} {set def "[string range $def 1 end] \037(\037locked\037)\037"}
           putserv "PRIVMSG $chan :\002$word\002\[$count\]\037:\037 $def"
           }
      }
     close $df
     return 1
  }
}

proc pub_setdef {nick uhost hand chan arg} {
  global dictdir
  if {[llength $arg] < 2} {
    putserv "NOTICE $nick :\002usage\002\037:\037 !define <word> <definition>"
    return 0
  }
  set word [string tolower [lindex $arg 0]]
  set def [lrange $arg 1 end]
  if {[string index $def 0] == "@" && ![matchattr $hand m] && ![matchchanattr $hand m $chan]} {
     set def [string range $def 1 end]
  }
  set def "$hand $def"
  set df [open $dictdir/$word.def a+]
  puts $df $def
  close $df
  putserv "NOTICE $nick :added definition \002\"[lrange $def 1 end]\"\002 to \002$word\002."
  return 1
}

proc pub_remdef {nick uhost hand chan arg} {
  global dictdir
  if {[llength $arg] < 2} {
    putserv "NOTICE $nick :\002usage\002\037:\037 !remove <word> <definition number>"
    return 0
  }
  set word [string tolower [lindex $arg 0]]
  if {![file exists $dictdir/$word.def]} {
      putserv "NOTICE $nick :unknown word\037:\037 \002$word\002"
      return 0
  }
  set del [lindex $arg 1]
  set df [open $dictdir/$word.def r]
  set dfn [open $dictdir/$word.new w]
  set count "0"
  set cflag "0"
  while {![eof $df]} {
    set def [gets $df]
    if {$def != ""} {
      incr count
      if {$count != $del} {
         puts $dfn $def
      } else {
         if {[string index [lindex $def 1] 0] != "@" || [matchattr $hand m] || [matchchanattr $hand m $chan]} {
            set cflag "1"
         } else {
           puts $dfn $def
         }
      }
    }
  }
  close $df
  close $dfn
  exec mv $dictdir/$word.new $dictdir/$word.def
  if {$cflag == "1"} {
     if {$count == "1"} {exec rm $dictdir/$word.def}
     putserv "NOTICE $nick :removed definition \002$del\002 from \002$word\002."
     return 1
  } else {
     putserv "NOTICE $nick :unable to remove definition \002$del\002 from \002$word\002."
  }
}

proc pub_whodef {nick uhost hand chan arg} {
   global dictdir
   if {$arg == ""} {
      putserv "NOTICE $nick :\002usage\002\037:\037 !whodef <word>"
      return 0
      }
   set word [string tolower [lindex $arg 0]]
   if {![file exists $dictdir/$word.def]} {
      putserv "NOTICE $nick :unknown word\037:\037 \002$word\002"
   } else {
      set count "0"
      set df [open $dictdir/$word.def r]
      while {![eof $df]} {
        set def [gets $df]
        if {$def != ""} {
           incr count
           set who [lindex $def 0]
           set def [lrange $def 1 end]
           if {[string index $def 0] == "@"} {set def "[string range $def 1 end] \037(\037locked\037)\037"}
           putserv "NOTICE $nick :\002$word\002\[$count\]\037:\037 $def \002\[\002$who\002\]\002"
           }
      }
     close $df
     return 1
  }
}

proc pub_deldef {nick uhost hand chan arg} {
   global dictdir
   if {$arg == ""} {
      putserv "NOTICE $nick :\002usage\002\037:\037 !deldef <word>"
      return 0
      }
   set word [string tolower [lindex $arg 0]]
   if {![file exists $dictdir/$word.def]} {
      putserv "NOTICE $nick :unknown word\037:\037 \002$word\002"
   } else {
      exec rm $dictdir/$word.def
      putserv "NOTICE $nick :removed word\037:\037 \002$word\002"
      return 1
   }
}

proc pub_lockdef {nick uhost hand chan arg} {
  global dictdir
  if {[llength $arg] < 2} {
    putserv "NOTICE $nick :\002usage\002\037:\037 !lokdef <word> <definition number>"
    return 0
  }
  set word [string tolower [lindex $arg 0]]
  if {![file exists $dictdir/$word.def]} {
      putserv "NOTICE $nick :unknown word\037:\037 \002$word\002"
      return 0
  }
  set lock [lindex $arg 1]
  set df [open $dictdir/$word.def r]
  set dfn [open $dictdir/$word.new w]
  set count "0"
  set cflag "0"
  while {![eof $df]} {
    set def [gets $df]
    if {$def != ""} {
      incr count
      if {$count != $lock} {
         puts $dfn $def
      } else {
         if {[string index [lindex $def 1] 0] != "@"} {
            set def "[lindex $def 0] @[lrange $def 1 end]"
            set cflag "1"
         }
         puts $dfn $def
      }
    }
  }
  close $df
  close $dfn
  exec mv $dictdir/$word.new $dictdir/$word.def
  if {$cflag == "1"} {
     return 1
     putserv "NOTICE $nick :locked definition \002$lock\002 from \002$word\002."
  } else {
     putserv "NOTICE $nick :unable to lock definition \002$lock\002 from \002$word\002."
     putserv "NOTICE $nick :definition may have been locked already or does not exist."
  }
}

proc pub_unlockdef {nick uhost hand chan arg} {
  global dictdir
  if {[llength $arg] < 2} {
    putserv "NOTICE $nick :\002usage\002\037:\037 !ulkdef <word> <definition number>"
    return 0
  }
  set word [string tolower [lindex $arg 0]]
  if {![file exists $dictdir/$word.def]} {
      putserv "NOTICE $nick :unknown word\037:\037 \002$word\002"
      return 0
  }
  set lock [lindex $arg 1]
  set df [open $dictdir/$word.def r]
  set dfn [open $dictdir/$word.new w]
  set count "0"
  set cflag "0"
  while {![eof $df]} {
    set def [gets $df]
    if {$def != ""} {
      incr count
      if {$count != $lock} {
         puts $dfn $def
      } else {
         if {[string index [lindex $def 1] 0] == "@"} {
            set def "[lindex $def 0] [string range [lrange $def 1 end] 1 end]"
            set cflag "1"
         }
         puts $dfn $def
      }
    }
  }
  close $df
  close $dfn
  exec mv $dictdir/$word.new $dictdir/$word.def
  if {$cflag == "1"} {
     putserv "NOTICE $nick :unlocked definition \002$lock\002 from \002$word\002."
     return 1
  } else {
     putserv "NOTICE $nick :unable to unlock definition \002$lock\002 from \002$word\002."
     putserv "NOTICE $nick :definition may have been unlocked already or does not exist."
  }
}

proc pub_helpdef {nick uhost hand chan arg} {
   putserv "NOTICE $nick :+----> \002WhatIs\037?\037\002 v1.0 -+- by \037\[\037mh.tric\037\]\037 -+- \002mh@tric.org\002"
   putserv "NOTICE $nick :| !whatis - shows definitions for a word"
   putserv "NOTICE $nick :| !define - adds definition to a word"
   putserv "NOTICE $nick :: !remdef - removes definition from a word"
   putserv "NOTICE $nick :. \002!deldef\002 - deletes an entire word                  ."
   putserv "NOTICE $nick :  \002!whodef\002 - shows definitions for a word with names :"
   putserv "NOTICE $nick :  \002!lokdef\002 - locks a definition for a word           |"
   putserv "NOTICE $nick :  \002!ulkdef\002 - unlocks a definition for a word         |"
   putserv "NOTICE $nick : commands shown above in bold for masters only <----+"
   return 1
}
